const AutoCompleteService = Class.extend({
    AUTOCOMPLETE_URL: MP_SITE_URL + '/autocomplete/hosts_filter?query=',

    search: function(query) {
        const url = this.AUTOCOMPLETE_URL + encodeURIComponent(query);
        return this.$http.get(url, {
            cache: false
        });

    }
});


(function() {

    const autoCompleteServiceProvider = Class.extend({
        instance: new AutoCompleteService(),
        $get: ['$http', function($http) {
            this.instance.$http = $http;
            return this.instance;
        }]
    });

    angular.module('autoCompleteServiceModule', [])
        .provider('autoCompleteService', autoCompleteServiceProvider);
}());
