'use strict';
/*common functions */

angular.module('commonHelper', [])
    .factory('commonHelper',
            ['$rootScope',
    function ($rootScope) {
    var helper = {};


    // Check if object is empty
    // return true if object is empty
    helper._isObjEmpty = function(o)
    {
        for(var p in o) {
            if (o[p] != o.constructor.prototype[p]) {
                return false;
            }
        }
        return true;
    };


    /**
    *  Truncate string by length
    *
    * {{some_text | cut:true:100:' ...'
    *   wordwise (boolean) - if true, cut only by words bounds,
    *   max (integer) - max length of the text, cut to this number of chars,
    *   tail (string, default: ' …') - add this string to the input string if the string was cut.
    */
    helper.truncateString = function (value, wordwise, max, tail) {

            if (!value) return '';

            max = parseInt(max, 10);
            if (!max) return value;
            if (value.length <= max) return value;

            value = value.substr(0, max);
            if (wordwise) {
                var lastspace = value.lastIndexOf(' ');
                if (lastspace !== -1) {
                    value = value.substr(0, lastspace);
                }
            }

            return value + (tail || ' …');
        };


    return helper;
}]);