import { createAsyncThunk } from '@reduxjs/toolkit';
import Api from '@northern.tech/store/api/general-api';

const profileApi = '/profileApi/user';
const profileAdiitonalDataApi = '/profileApi/additional_data';

export const getRoles = createAsyncThunk(
  'users/getRoles',
  async () => {
    const { data } = await Api.get('/dashboard/dashboardsapi/roles');
    return data;
  }
);

export const getProfileData = createAsyncThunk(
  'users/getProfileData',
  async () => {
    const { data } = await Api.get(profileApi);
    return data;
  }
);

export const getAdditionalData = createAsyncThunk(
  'users/getAdditionalData',
  async (key: string) => {
    const { data } = await Api.get(`${profileAdiitonalDataApi}?key=${key}`);
    return {key, value: data};
  }
);

export const updateAdditionalData = createAsyncThunk(
  'users/updateAdditionalData',
  async ({key, value}: {key: string, value: boolean}) => {
    await Api.post(profileAdiitonalDataApi, {key, value});
    return {key, value};
  }
);
