import React from 'react';
import {
    Box,
    TextField,
    FormHelperText
} from '@mui/material';

interface ListFormProps {
    onChange: (value: string[]) => void;
    errors: Record<string, string>;
    value?: string[] | string;
}

interface ListValueViewProps {
    value: string[] | string;
}

const ListForm: React.FC<ListFormProps> = ({
    onChange,
    errors,
    value
}) => {
    const displayValue = Array.isArray(value) ? value.join("\n") : (value || '');

    return (
        <Box sx={{ mt: 2 }}>
            <TextField
                fullWidth
                variant="outlined"
                multiline
                rows={4}
                size="small"
                placeholder="Value"
                value={displayValue}
                onChange={(e) => onChange(e.target.value.split("\n"))}
                error={!!errors.item_value}
                helperText={errors.item_value}
            />
            <FormHelperText>Press enter to add new value</FormHelperText>
        </Box>
    );
};

export const ValueView: React.FC<ListValueViewProps> = ({ value }) => {
    const displayValue = Array.isArray(value) ? value.join("\n") : (value || '');

    return (
        <TextField
            fullWidth
            variant="outlined"
            multiline
            rows={4}
            size="small"
            placeholder="Value"
            value={displayValue}
        />
    );
};

export default ListForm;
