<?php
require_once(APPPATH . 'modules/advancedreports/classes/ApiResponseInventoryDataDecorator.php');
require_once(APPPATH . 'modules/advancedreports/classes/ApiResponseInventoryVariablesDecorator.php');

/**
 * Class InventoryAPIService
 */
class InventoryAPIService
{
    /** @var HttpClientInterface $restClient */
    private $restClient = null;

    public function __construct($restClient)
    {
        $this->restClient = $restClient;
    }

    /**
     * @return mixed|string
     * @throws Exception
     */
    public function getVariables()
    {
        $response = $this->restClient->get('/inventory/attributes-dictionary');
        $responseProcessed = (new ApiResponseInventoryVariablesDecorator($response))->getProcessed();

        return $responseProcessed;
    }

    /**
     * @param integer $id
     * @param array $data
     * @return mixed|string
     * @throws Exception
     */
    public function updateVariable($id, $data)
    {
        $response = $this->restClient->patch('/inventory/attributes-dictionary/' . $id, $data);
        $responseProcessed = (new ApiResponseInventoryVariablesDecorator($response))->getProcessed();

        return $responseProcessed;
    }

    /**
     * @param $params
     * @return mixed|string
     * @throws Exception
     */
    public function getData($params)
    {
        $response = $this->restClient->post('/inventory', $params);
        $responseProcessed = (new ApiResponseInventoryDataDecorator($response))->getProcessed();

        return $responseProcessed;
    }

}
