<script type="text/ng-template" id="addWidget.html">
    <div class="modal-header">
        <button type="button" class="close" ng-click="modalWindow.close('addWidget')"><i class="bi bi-x"></i></button>
        <h2>Add widget</h2>
    </div>
    <div class="modal-body addWidgetModal">
        <div ng-hide="clickedAlert || clickedInventory || clickedCompliance || clickedSingleAlert"  class="tabs margin-bottom" ng-init="tab='create'">
            <a href="javascript:void(0)" ng-click="tab='create'" ng-class="{'selected': tab === 'create'}">Create new widget</a>
            <a href="javascript:void(0)"  ng-click="tab='existing'" ng-class="{'selected': tab === 'existing'}">Add existing widget</a>
        </div>
        <div id="notification_block_wrapper" data-notifications></div>
        <div class="tabs-content" ng-show="!clickedAlert && !clickedInventory && !clickedCompliance && !clickedSingleAlert">
            <div ng-show="tab === 'create'">
                <div>
                    <div id="widget-panel" ng-click="initComplianceForm();"  class="widget-panel">
                        <h3>Compliance report widget</h3>
                        <div class="widget-panel-img-compliance widget-panel-img"></div>
                    </div>
                </div>
                <div>
                    <div id="widget-panel" ng-click="initInventoryForm('pie');"  class="widget-panel">
                        <h3>Pie chart for inventory data</h3>
                        <div class="widget-panel-img-pie widget-panel-img"></div>
                    </div>
                </div>
                <div>
                    <div class="widget-panel" ng-click="clickedSingleAlert=true">
                        <h3>Alert widget</h3>
                        <div class="widget-panel-img-single-alert widget-panel-img"></div>
                    </div>
                </div>
                <div>
                    <div id="widget-panel" ng-click="initInventoryForm('table');"  class="widget-panel">
                        <h3>Table chart for inventory data</h3>
                        <div class="widget-panel-img-table widget-panel-img"></div>
                    </div>
                </div>
                <div>
                    <div id="widget-panel" ng-click="initInventoryForm('bar');"  class="widget-panel">
                        <h3>Bar chart for inventory data</h3>
                        <div class="widget-panel-img-bar widget-panel-img"></div>
                    </div>
                </div>
                <div>
                    <div class="widget-panel" ng-click="clickedAlert=true">
                        <h3>Multiple alerts widget</h3>
                        <div class="widget-panel-img-alert widget-panel-img"></div>
                    </div>
                </div>
                <div>
                    <div id="widget-panel" ng-click="initInventoryForm('solidgauge');"  class="widget-panel">
                        <h3>Gauge for inventory data</h3>
                        <div class="widget-panel-img-gauge widget-panel-img"></div>
                    </div>
                </div>
            </div>
            <div  ng-show="tab === 'existing'">
                <div ng-class="{'disabled': clickedChanges}">
                    <div id="changes-panel" ng-click="addWidget('changes', 'Changes');"  class="widget-panel">
                        <h3>Changes</h3>
                        <div class="widget-panel-img-changes widget-panel-img"></div>
                    </div>
                </div>
                <div ng-class="{'disabled': clickedHostCount}">
                    <div id="changes-panel" ng-click="addWidget('hostCount', 'Newly bootstrapped hosts');"  class="widget-panel">
                        <h3>Newly bootstrapped hosts</h3>
                        <div class="widget-panel-img-new widget-panel-img"></div>
                    </div>
                </div>
                <div ng-class="{'disabled': clickedDecommissionedHosts}">
                    <div id="changes-panel" ng-click="addWidget('decommissionedHosts', 'Decommissioned hosts');"  class="widget-panel">
                        <h3>Decommissioned hosts</h3>
                        <div class="widget-panel-img-decommissioned widget-panel-img"></div>
                    </div>
                </div>
                <div ng-class="{'disabled': clickedFileChanges}">
                    <div id="changes-panel" ng-click="addWidget('fileChanges', 'File changes');"  class="widget-panel">
                        <h3>File changes count</h3>
                        <div class="widget-panel-img-files-changes widget-panel-img"></div>
                    </div>
                </div>
                <div ng-class="{'disabled': clickedNotKeptNeverRepaired}">
                    <div id="changes-panel" ng-click="addWidget('notKeptNeverRepaired', 'Not kept, not repaired count');"  class="widget-panel">
                        <h3>Not kept, not repaired count</h3>
                        <div class="widget-panel-img-not-kept widget-panel-img"></div>
                    </div>
                </div>
            </div>
        </div>

        <div ng-show="clickedAlert || clickedSingleAlert" >
        <form id="alertWidgetForm" enter-press="createWidget()" class='form-horizontal'>

            <div class='control-group'>
                <h4>Step 1</h4>
                <p>Choose a name for your new <span class="italic">alerts</span> widget:</p>
                <input id="widget-name" type='text' ng-init="widgetData.name = ''" ng-model='widgetData.name' maxlength='100' placeholder='Name'>
                <p class='help-block'>if left blank, the widget will be named automatically</p>
            </div>
            <div class='control-group'>
                <h4>Step 2</h4>
                <p>Choose 'Continue' to create the first <span class="italic">alert</span> for this widget.</p>
            </div>
        </form>

        </div>
        <div ng-show="clickedInventory" >
        <form id="inventoryWidgetForm" enter-press="addInventoryWidget()" class='form-horizontal'>

            <div class='control-group'>
                <h4>Step 1</h4>
                <p>Choose a name for your new widget:</p>
                <input id="widget-name" type='text' ng-init="widgetData.name = ''" ng-model='widgetData.name' maxlength='100' placeholder='Name'>
                <p class='help-block'>if left blank, the widget will be named automatically</p>
            </div>

            <div class='control-group'>
                <h4>Step 2</h4>
                <p>Select the inventory attribute you would like the widget to show:</p>
                <select
                        required
                        data-placeholder="Select an attribute"
                        chosen
                        name="inventoryAttribute"
                        ng-init="widgetData.inventoryAttribute = ''"
                        ng-model="widgetData.inventoryAttribute"
                        watch="inventoryAttributeValues"
                        ng-options="option.name as option.value group by option.category for option in inventoryAttributeValues"
                        class="chosen-dropdown"
                >
                </select>
            </div>
            <div ng-if="widgetData.chartType == 'solidgauge'" class="solidgauge">
                <h5>Gauge settings:</h5>
                <div class="control-group">
                    <label class="control-label">Min value</label>
                    <div class="controls">
                        <input  type="number" ng-model='widgetData.min'  maxlength="5" >
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">Max value</label>
                    <div class="controls">
                        <input  type="number" ng-model='widgetData.max' maxlength="5" >
                    </div>
                </div>
                <div>
                    <div class="control-group">
                        <label class="control-label"> Colors direction</label>
                        <div class="controls">
                            <label for="mode" class="radio inline">
                                <input type="radio" name="colorsDirection" ng-init="widgetData.startColor = 'green'" ng-model='widgetData.startColor' value="green" checked="checked">
                                From green to red
                            </label>
                            <label for="mode" class="radio inline">
                                <input type="radio" name="colorsDirection" ng-model='widgetData.startColor' value="red">
                                From red to green
                            </label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="text-error" ng-repeat="error in widgetData.errors" >{{error}}</div>
        </form>

        </div>
        <div ng-show="clickedCompliance">
            <form id="complianceWidgetForm" enter-press="addComplianceWidget()" class='form-horizontal'>
                <div class='control-group'>
                    <h4>Step 1</h4>
                    <p>Choose a name for your new widget:</p>
                    <input id="widget-name" type='text' ng-init="widgetData.name = ''" ng-model='widgetData.name'
                           maxlength='100' placeholder='Name'>
                    <p class='help-block'>if left blank, the widget will be named automatically</p>
                </div>

                <div class='control-group'>
                    <h4>Step 2</h4>
                    <p>Select a compliance report you would like the widget to show:</p>
                    <select
                            required
                            data-placeholder="Select a compliance report"
                            chosen
                            name="complianceReport"
                            ng-init="widgetData.complianceReport = ''"
                            ng-model="widgetData.complianceReport"
                            watch="complianceReports"
                            ng-options="option.value as option.name for option in complianceReports"
                            class="chosen-dropdown"
                    >
                    </select>
                </div>
                <div class="text-error" ng-repeat="error in widgetData.errors">{{error}}</div>
            </form>
        </div>
    </div>
    <div class="modal-footer">
        <button ng-show="clickedAlert || clickedSingleAlert" id="continue" class="btn btn-large btn-primary" ng-click="createWidget(clickedSingleAlert)">Continue</button>
        <button ng-show="clickedInventory || clickedCompliance" id="save" class="btn btn-large btn-primary" ng-click="clickedInventory ? addInventoryWidget() : addComplianceWidget()">Save</button>
        <a class="btn btn-large" ng-click="modalWindow.close('addWidget')" href="javascript:void(0)">Close</a>
    </div>
    <script>
        // scroll dropdown into view when options are shown
        $(".chosen-dropdown").chosen().on(
            'chosen:showing_dropdown',
            () => setTimeout(() => document.querySelector('.chosen-container-active').scrollIntoView(), 200)
        );
</script>
</script>
