class BaseInventoryWidget {
    constructor(payload, data) {
        this.payload = payload;
        this.data = data;
        this.variable = payload.inventoryAttribute;

        this.allowedItemsForClickAction = ['rect', 'path'];
    }

    clickAction(event, filterValue = null) {

        if (event && !this.allowedItemsForClickAction.includes(event.target.nodeName)) {
            return false;
        }

        sessionStorage.removeItem('inventory_sql');
        let reportURL = MP_SITE_URL + "/reports/inventory?columns=Host name," + this.variable;
        if (filterValue !== null && typeof filterValue == "string") {
            let filter = {
                attribute_name: `attribute_name=${this.variable}`,
                condition: "=",
                type: "string",
                label: this.variable,
                value: filterValue
            };
            reportURL += `&filter=${JSON.stringify(filter)}`
        }
        window.location.href = encodeURI(reportURL);
    }
}

class BaseBarPieWidget extends BaseInventoryWidget {
    getLegendTitle() {
        return '<div style="width: 225px;"><span style="float: left;">' + this.variable + ': </span><span style="float: right">Hosts</span></div>';
    }

    getLabel(data) {
        let name = data.name;
        if (name.length > 15) {
            name = name.substr(0, 15) + '..';
        }
        return '<div><span style="float: left;">' + name + ': </span>' + '<span style="float: right">' + data.y + '</span></div>';
    }
}

window.BaseInventoryWidget = BaseInventoryWidget;
window.BaseBarPieWidget = BaseBarPieWidget;
