angular.module('customFilter', [])
    .filter('filterObject', function () {
        return function (input, search, prop) {
            if (!input || !search) {
                return input;
            }
            const expected = search.toString().toLowerCase();
            let result = {};
            angular.forEach(input, function (value, key) {
                const actual = prop ? value[prop].toString().toLowerCase() : value.toString().toLowerCase();
                if (actual.indexOf(expected) !== -1) {
                    result[key] = value;
                }
            });
            return result;
        }
    })
    .filter('objectLength', () => (input) => Object.keys(input).length);
