<div ng-show="$parent.showFilter" class="filter-title">
    Filter by host
</div>
<div ng-show="$parent.showFilter" class="host-filter">
    <div class="controls hostFilter">
        <select class="mySelect"
                data-placeholder="{{searchPlaceholder}}"
                chosen-auto-complete
                ng-model="searchCompleteSelected"
                name="searchCompleteSelected"
                watch="searchComplete"
                ng-options="item.name group by item.type for item in searchComplete track by item.id"
                ng-change="selectClass(searchCompleteSelected)"
        >
        </select>
    </div>

    <form>
        <div  class="excludeButton" ng-show="!searchCompleteHost && !hideSpecificHostsFilter" ng-class="{'border-top':$parent.widgetData.length}">
            <div title="Select or exclude specific hosts from the host group" class="btn btn-link btn-large" role="button" ng-click="showHost()">Select/exclude hosts</div>
        </div>

    </form>

</div>

<br />
<div style="position:relative" class="filterButtons" ng-show="showenvironmentfilterbuttons">
    <div class="filter-buttons inline-block">
        <a class="margin-right-small" ng-href="" ng-click="clearAll()">Clear all fields</a>
        <button class="btn btn-large" ng-click="$parent.showFilter=false">Cancel</button>
        <button class="btn btn-large btn-primary" ng-click="applyFilter()">Apply</button>
    </div>
</div>

<script type="text/ng-template" id="hostSelectionModal.html" class="includeExcludeModal">

    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"  ng-click="hostSearch =''; close()">
            <i class="bi bi-x"></i>
        </button>
        <h2>Hosts to activate on</h2>
    </div>
    <div class="row modal-body no-padding" style="min-height: 400px;">
        <div class="inclExcl span6">
            <div class="class-search">


                <div class="mtb-10">
                    Select or exclude specific hosts from: {{searchCompleteSelected.name.split('-').join('')}}
                </div>

                <div ng-show="showHosts&&totalHostList.length == 0">
                    <p>No hosts matched your criteria</p>
                </div>

                <span class="searchBlock">
                        <input ng-model="modalData.searchString"  name="modalData.searchString"
                               type="text" placeholder="Search hostname, IP">
                        <span ng-click="modalData.searchString = ''" ng-show="modalData.searchString != ''" class="clearSearch">x</span>
                        <ul class="unstyled">
                            <li ng-repeat="(key, host) in modalData.searchResult">
                                <a ng-click="addExcludedHost(host);">{{host.hostname}}</a>
                            </li>
                        </ul>
                </span>

                <div class="host-list" ng-show="totalHostList.length>0">
                    <ul class="unstyled">
                        <li ng-repeat="host in totalHostList">
                            <div class="checkbox">
                                <div title="{{host.hostname}}" class="host-list_name">{{host.hostname}}</div>
                                <div style="float: right;">
                                    <span class="btn-select"
                                          ng-show="isEmptyObject(excludedHosts) && !isHostIncluded(host.id)"
                                          ng-click="addIncludedHost(host)">Select</span>
                                    <span class="btn-select"
                                          ng-show="isEmptyObject(includedHosts) && !isHostExcluded(host.id)"
                                          ng-click="addExcludedHost(host)">Exclude</span>

                                    <span class="btn-select" ng-show="isHostIncluded(host.id)"
                                          ng-click="deleteIncludedHosts(host.id);">Selected ×</span>
                                    <span class="btn-select" ng-show="isHostExcluded(host.id)"
                                          ng-click="deleteExcludedHosts(host.id);">Excluded ×</span>
                                </div>
                            </div>
                        </li>
                    </ul>


                </div>
                <!--- PAGINATION  START -->
                <div class="float-left paginator_SE">

                    <div class="pull-right pagination" ng-show="paginator.resultCount > paginator.defaultRowsPerPage">
                        <ul class="pull-left">
                            <li ng-if="paginator.page != 1 && paginator.pages > 5">
                                <a title="Go to First Page" ng-click="paginator.reloadView(1)"
                                   href="javascript:void(0)">First</a>
                            </li>
                            <li ng-if="paginator.page != 1">
                                <a title="Go to Previous Page"
                                   ng-click="paginator.reloadView(paginator.page-1 || 1)" href="javascript:void(0)">&laquo;</a>
                            </li>


                            <li ng-repeat="item in paginator.resultPagesList"
                                ng-class="{active: item == paginator.page}">
                                <span ng-if="item == paginator.page">{{item}}</span>
                                <a ng-if="item != paginator.page" title="Go to Page {{item}}"
                                   ng-click="paginator.reloadView(item)" href="javascript:void(0)">{{item}}</a>
                            </li>


                            <li ng-if="paginator.page != paginator.pages ">
                                <a title="Go to Next Page"
                                   ng-click="paginator.reloadView(paginator.page+1 || paginator.pages)"
                                   href="javascript:void(0)">&raquo;</a>
                            </li>
                            <li ng-if="paginator.page != paginator.pages && paginator.pages > 5">
                                <a title="Go to Last Page" ng-click="paginator.reloadView(paginator.pages)"
                                   href="javascript:void(0)">Last</a>
                            </li>
                        </ul>

                    </div>
                </div>
                <!--- PAGINATION END -->
            </div>
        </div>
        <div class="span4">
            <div ng-hide="isEmptyObject(excludedHosts)">
                Excluding {{getExcludedHostsCount()}}
                <p class="help-block">Activate on {{searchCompleteSelected.name.split('-').join('')}} excluding these hosts</p>
                <div class="host-list-exclude">
                    <ul class="unstyled">
                        <li ng-repeat="(key, host) in excludedHosts">
                            {{host}}
                            <a type="button" ng-click="deleteExcludedHosts(key);">
                                ×
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <div ng-hide="isEmptyObject(includedHosts)">

                Selected {{getIncludedHostsCount()}}
                <p class="help-block">Activate only on these hosts</p>
                <div class="host-list-include">
                    <ul class="unstyled">
                        <li ng-repeat="(key, host) in includedHosts">
                            {{host}}
                            <a type="button" ng-click="deleteIncludedHosts(key);">
                                ×
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <button class="btn  clearAll" ng-show="!isEmptyObject(excludedHosts) || !isEmptyObject(includedHosts)"
                    ng-click="clearAll()">clear all
            </button>
        </div>
    </div>


    <div class="modal-footer">
        <button class="btn btn-large btn-primary" ng-click="useSelectedHost()">Save </button>
    </div>
</script>
