const notify = (function () {
  const commonProps = {
    autoclose: true,
    customWrapper: '<div class="cf-notification"></div>',
    showCloseButton: false,
    effect: 'slide'
  };
  return {
    error: function (text, props = {}) {
      new Notify({
        text,
        status: 'error',
        customIcon: '<i class="bi bi-exclamation-triangle-fill"></i>',
        ...commonProps,
        ...props
      });
    },

    success: function (text, props = {}) {
      new Notify({
        text,
        customIcon: '<i class="bi bi-check-circle-fill"></i>',
        ...commonProps,
        ...props
      });
    },

    info: function (text, props = {}) {
      new Notify({
        text,
        status: 'info',
        customIcon: '<i class="bi bi-hourglass-split"></i>',
        ...commonProps,
        ...props
      });
    }
  };
})();
