import * as React from "react";
import createEmotionServer from "@emotion/server/create-instance";
import { CacheProvider } from "@emotion/react";
import createCache from "@emotion/cache";
/**
 * @deprecated Use tss-react/next instead.
 * @see <https://docs.tss-react.dev/ssr/next> */
export function createEmotionSsrAdvancedApproach(options) {
    let muiCache = undefined;
    const createMuiCache = () => (muiCache = createCache(options));
    function EmotionCacheProvider(props) {
        const { children } = props;
        return (React.createElement(CacheProvider, { value: muiCache !== null && muiCache !== void 0 ? muiCache : createMuiCache() }, children));
    }
    function withEmotionCache(Document, params) {
        const { getExtraCaches = () => [] } = params !== null && params !== void 0 ? params : {};
        return class DocumentWithEmotionCache extends Document {
            static async getInitialProps(ctx) {
                const emotionServers = [createMuiCache(), ...getExtraCaches()]
                    .sort((a, b) => getPrepend(a) === getPrepend(b)
                    ? 0
                    : getPrepend(a)
                        ? -1
                        : 1)
                    .map(createEmotionServer);
                const initialProps = await Document.getInitialProps(ctx);
                return {
                    ...initialProps,
                    "styles": [
                        ...React.Children.toArray(initialProps.styles),
                        ...emotionServers
                            .map(({ extractCriticalToChunks }) => extractCriticalToChunks(initialProps.html)
                            .styles.filter(({ css }) => css !== "")
                            .map(style => (React.createElement("style", { nonce: options.nonce, "data-emotion": `${style.key} ${style.ids.join(" ")}`, key: style.key, dangerouslySetInnerHTML: {
                                "__html": style.css
                            } }))))
                            .reduce((prev, curr) => [...prev, ...curr], [])
                    ]
                };
            }
        };
    }
    return { EmotionCacheProvider, withEmotionCache };
}
function getPrepend(cache) {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return !!cache.sheet.prepend;
}
