<?php

class VcsSettingsLib
{

    /**
     * @var mixed
     */
    public static $vcsConfig;

    /**
     * VcsSettingsLib constructor.
     */
    function __construct()
    {
        $filePath = VCSCONFIGPATH;
        syslog(LOG_DEBUG, 'Reading DC configuration file from path :' . $filePath);
        self::$vcsConfig = $this->read_from_file($filePath);
    }

    /**
     * @param $filePath
     *
     * @return mixed
     */
    function read_from_file($filePath)
    {

        $fileContent = file_get_contents($filePath);
        $jsonArray   = json_decode($fileContent, true);

        return $jsonArray;
    }


    /**
     * Hardcode the key path to admin
     */
    function get_dc_user_ssh_key_directory($username = 'admin')
    {

        return self::$vcsConfig['keyPath'] . DIRECTORY_SEPARATOR . 'admin' . DIRECTORY_SEPARATOR . '.ssh';
    }

    /**
     * @return mixed
     */
    function get_dc_user_ssh_key_name()
    {

        return self::$vcsConfig['privateKeyName'];
    }

    /**
     * @return mixed
     */
    function get_user_ssh_key_path()
    {
        return self::get_dc_user_ssh_key_directory() . DIRECTORY_SEPARATOR . self::get_dc_user_ssh_key_name();
    }

    /**
     * @return string
     */
    function get_dc_user_ssh_key()
    {

        return $this->get_dc_user_ssh_key_directory() . DIRECTORY_SEPARATOR . $this->get_dc_user_ssh_key_name();
    }

    /**
     * @return mixed
     */
    function get_dc_staging_repository()
    {

        return self::$vcsConfig['gitStagingRepository'];
    }

    /**
     * @return string
     */
    function get_dc_update_script_template_path()
    {

        return FCPATH . self::$vcsConfig['gitUpdateScriptTemplatePath'];
    }

    /**
     * @return mixed
     */
    function get_dc_update_script_path()
    {

        return self::$vcsConfig['gitUpdateScriptPath'];
    }

    /**
     * @return string
     */
    function get_dc_params_script_name()
    {
        return self::$vcsConfig['gitUpdateParamsScriptName'];
    }

    /**
     * @return string
     */
    function get_dc_params_file_path()
    {
        return $this->get_dc_update_script_path() . DIRECTORY_SEPARATOR . $this->get_dc_params_script_name();
    }


    /**
     * @return mixed
     */
    function get_dc_git_working_branch()
    {

        return self::$vcsConfig['gitLocalWorkingBranch'];
    }

    private $sensitiveData = ['GIT_PASSWORD'];

    public function parseSettings($paramFile, $hideSensitiveData = true) : array
    {
        $data    = array();
        $content = file_get_contents($paramFile);
        $rows    = explode("\n", $content);
        array_shift($rows);
        $pattern = '/^(\w+)="(.*)"$/i';

        foreach ($rows as $row) {
            if (preg_match($pattern, $row, $matches)) {
                $key = $matches[1];
                $value = $hideSensitiveData && in_array($key, $this->sensitiveData) ? '' : $matches[2];
                $data[$key] = $value;
            }
        }

        return $data;
    }

}