<?php
class body_model extends Cf_Model
{

    function getAllBodyByType($type){
       try
        {
            $rawdata = cfpr_body_list($type, ".*");
            $data = $this->checkData($rawdata);
            if (is_array($data) && $this->hasErrors() == 0)
            {
                return $data;
            }
            else
            {
                throw new Exception($this->getErrorsString());
            }
        }
        catch (Exception $e)
        {
            log_message(log_level_for_exception($e), $e->getMessage() . " " . $e->getFile() . " line:" . $e->getLine());
            throw $e;
        }
    }

    function getBodyDetail($body,$type){
       try
        {
            $rawdata = cfpr_body_details($type, $body);
            $data = $this->checkData($rawdata);
            if (is_array($data) && $this->hasErrors() == 0)
            {
                return $data;
            }
            else
            {
                throw new Exception($this->getErrorsString());
            }
        }
        catch (Exception $e)
        {
            log_message(log_level_for_exception($e), $e->getMessage() . " " . $e->getFile() . " line:" . $e->getLine());
            throw $e;
        }
    }
}
?>
