/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*global Class, MP_SITE_URL, angular*/
'use strict';

/*
 * Service for hubManagement
 *
 **/


var HubManagementServiceClass = Class.extend({
    MODULE_URL: MP_SITE_URL + '/hub_management/api',

    enableSuperhub: function () {
        var url = this.MODULE_URL + '/enableSuperhub';
        return this.$http({
            method: 'GET',
            url: url,
            transformRequest: angular.identity
        });
    },

    enableFeeder: function () {
        var url = this.MODULE_URL + '/enableFeeder';
        return this.$http({
            method: 'GET',
            url: url,
            transformRequest: angular.identity
        });
    },

    gethubStatus: function () {
        var url = this.MODULE_URL + '/hubStatus';
        return this.$http({
            method: 'GET',
            url: url,
            transformRequest: angular.identity
        });
    },

    getHubInfo: function () {
        var url = this.MODULE_URL + '/hubInfo';
        return this.$http({
            method: 'GET',
            url: url,
            transformRequest: angular.identity
        });
    },

    addFeeder: function (data) {
        var url = this.MODULE_URL + '/addFeeder';
        return this.$http({
            method: 'POST',
            headers : {
                'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
            },
            data:  $.param(data),
            url: url,
            transformRequest: angular.identity
        });
    },

    editFeeder: function (id, data) {
        var url = this.MODULE_URL + '/editFeeder/' + id;
        return this.$http({
            method: 'POST',
            headers : {
                'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'
            },
            data:  $.param(data),
            url: url,
            transformRequest: angular.identity
        });
    },

    getRemoteHubs: function () {
        var url = this.MODULE_URL + '/remoteHubs';
        return this.$http({
            method: 'GET',
            url: url,
            transformRequest: angular.identity
        });
    },

    getRemoteHub: function (id) {
        var url = this.MODULE_URL + '/remoteHub/' + id;
        return this.$http({
            method: 'GET',
            url: url,
            transformRequest: angular.identity
        });
    },

    getSuperHub: function () {
        var url = this.MODULE_URL + '/superHub/';
        return this.$http({
            method: 'GET',
            url: url,
            transformRequest: angular.identity
        });
    },

});

(function () {
    var hubManagementServiceProvider = Class.extend({
        instance: new HubManagementServiceClass(),
        $get: ['$http', function ($http) {
            this.instance.$http = $http;
            return this.instance;
        }]
    });

    angular.module('hubManagementServiceModule', [])
        .provider('hubManagementService', hubManagementServiceProvider);
}());
