<?php

namespace CMDB\v2\Entities;

class CmdbEntryFactory
{
    public static function fromRequest(array $data, string $hostkey): CmdbHostEntry
    {
        $subentries = array_map(function ($subentry) use ($hostkey): CmdbHostSubEntry {
            return new CmdbHostSubEntry(
                id: null,
                entry_id: null,
                hostkey: $hostkey,
                item_name: $subentry['item_name'] ?? '',
                item_type: $subentry['item_type'] ?? '',
                item_value: $subentry['item_value'] ?? null,
            );
        }, ($data['entries'] ?? []));

        return new CmdbHostEntry(
            id: null,
            hostkey: $hostkey,
            name: $data['name'] ?? '',
            description: $data['description'] ?? '',
            tags: $data['tags'] ?? [],
            type: $data['type'] ?? '',
            meta: $data['meta'] ?? [],
            subentries: $subentries
        );
    }
}
