<?php

final class SharedGroupCmdbEntry
{
    public function __construct(
        public readonly ?int $id = null,
        public readonly int $group_id,
        public readonly string $type,
        public readonly string $name = '',
        public readonly string $description = '',
        public readonly array $tags = [],
        public readonly array $meta = [],
        public readonly ?array $subentries = [],
    ) {
    }

    public function toArray(): array
    {
        return [
            'group_id' => $this->group_id,
            'name' => $this->name,
            'description' => $this->description,
            'tags' => DatabaseHelper::toPgArray($this->tags),
            'type' => $this->type,
            'meta' => json_encode($this->meta),
        ];
    }
}
