angular.module('highChartsDirective', [])
    .directive('highCharts', ['$q', function () {
        Highcharts.setOptions({
            plotOptions: {
                pie: {
                    borderRadius: 0
                }
            }
        });
        return {
            restrict: 'A',
            scope: {
                config: '='
            },
            link: function (scope, element) {
                scope.$watch('config', function () {
                    Highcharts.chart(element[0].id, {
                        ...scope.config, exporting: {
                            enabled: false, // do not show an exporting menu by default
                            fallbackToExportServer: false // ensure local exporting
                        }
                    });
                }, true)

            }
        };
    }]);