<?php

abstract class BaseDiffConverter
{
    abstract function convert($diff);

    /**
     * @param $diff
     *
     * @return array
     */
    protected function parseDiffData($diff)
    {
        if (is_string($diff)) {
            $diff = $this->parseDiffStrings($diff);
        }

        $diffData = [];
        foreach ($diff as $index => $diffLine) {
            $diffLine = trim($diffLine, '"');
            $diffArray = explode(',', $diffLine);
            $diffData[$index] = [
                'operation' => array_shift($diffArray),
                'lineNumber' => array_shift($diffArray),
                'content' => str_replace('\"', '"', implode(',', $diffArray))
            ];
        }
        return $diffData;
    }

    /**
     * @param $diff
     *
     * @return mixed
     */
    private function parseDiffStrings($diff)
    {
        $regexOutput = [];
        //get all characters between quotes except escaped quotes
        preg_match_all('/"([^"\\\\]|\\\\.)*"/', $diff, $regexOutput);
        return $regexOutput[0];
    }
}
