<?php

class savedsearch extends Cf_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->library(array('table', 'cfe_table', 'pagination'));
        $this->load->helper('form');
        $this->carabiner->js('jquery.tablesorter.min.js');
        $this->carabiner->js('picnet.jquery.tablefilter.js');
        $this->carabiner->js('jquery.tablesorter.pager.js');

        $this->load->model('search_save_model');

        // if we have to overwrite advanced search to normal
        $this->load->model('advancedreports_model');
        $this->advancedreports_model->setRestClient($this->getRestClient());
    }

    function save()
    {
        // we will use username for RBAC
        $username = $this->session->userdata('username');

        $report_title = $this->input->post('report_title', true);
        $type         = $this->input->post('type'); // default - for predefined reports, advanced - for advanced reports
        $label        = $this->input->post('search_name', true);
        $searchUrl    = $this->input->post('search_url', false);
        $searchParams = $this->input->post('search_params', false);
        $promise_filter = $this->input->post('promise_filter', false);
        $details_for_view =$this->input->post('detailsForView', false);


        $overwrite = $this->input->post('overwrite', true);

        //cast
        $overwrite = ($overwrite == 'true' ? true: false);


        $data = array(
            'username'   => $username,
            'url'        => $searchUrl,
            'reportType' => $report_title,
            'type'       => $type,
            'label'      => $label,
            'date'       => time(),
            'params'     => $searchParams,
            'details'    => $details_for_view,
            'promise_filter' => $promise_filter
        );

        $obj = $this->search_save_model->insert($data, $overwrite);
        if ($obj)
        {
            respond_ok('Search successfully saved.');
            return;
        }
        else
        {
            $errors = $this->search_save_model->getErrors();
            $data = json_encode($errors);
            respond_internal_error($data);

            return;
        }
    }

    function listSavedSearches($reportTitle = '', $user = '')
    {
        $username = ($user) ? $user : $this->session->userdata('username');

        $filter = array('username' => $username, 'type' => 'default');

        if (trim($reportTitle) != '')
        {
            $filter['reportType'] = urldecode($reportTitle);
        }


        $result = $this->search_save_model->get_all_search($filter);
        $viewdata['data'] = $result;

        /* group by report type */
        $group = array();
        foreach ($result as $obj)
        {
            $title = $obj->getReportType();
            $group[$title][] = $obj;
        }
        $viewdata['group'] = $group;


        /* is ajax request only server partial view */
        if (is_ajax())
        {
            $this->load->view('/savesearch/view_saved_search', $viewdata);
            return;
        }

        $bc = array(
            'title' => $this->lang->line('breadcrumb_saved_search'),
            'url' => 'savedsearch/listSavedSearches/',
            'isRoot' => false
        );

        $this->breadcrumb->setBreadCrumb($bc);

        $data = array(
            'title' => $this->lang->line('mission_portal_title') . " - " . $this->lang->line('breadcrumb_saved_search'),
            'title_header' => "Saved search overview",
            'breadcrumbs' => $this->breadcrumblist->display()
        );

        $viewdata = array_merge($viewdata, $data);
        $this->template->load('template', '/savesearch/show_saved_search', $viewdata);
    }

    function delete($id = '')
    {

        $filter = array('id' => $id);
        $result = $this->search_save_model->delete($filter);
        if (!$result)
        {
            $this->output->set_status_header('404', 'cannot delete the record');
            return;
        }
    }




}
