document.addEventListener('DOMContentLoaded', function() {

    document.body.addEventListener('show', function(e) {
        if (e.target.classList.contains('accordion')) {
            const accordionHeading = e.target.previousElementSibling;
            if (accordionHeading && accordionHeading.classList.contains('accordion-heading')) {
                const icon = accordionHeading.querySelector('.accordion-toggle > i');
                if (icon) {
                    icon.classList.remove('icon-chevron-right');
                    icon.classList.add('icon-chevron-down');
                }
            }
        }
    });

    document.body.addEventListener('hide', function(e) {
        if (e.target.classList.contains('accordion')) {
            const icons = document.querySelectorAll('.accordion-toggle > i');
            icons.forEach(function(icon) {
                if (icon !== e.target.querySelector('i')) {
                    icon.classList.remove('icon-chevron-down');
                    icon.classList.add('icon-chevron-right');
                }
            });
        }
    });
});
