<?php

abstract class BaseRuleReport
{
    public const ALL_TYPE = 'all';
    public const PASSING_TYPE = 'passing';
    public const FAILING_TYPE = 'failing';

    protected $conditionMustBeMet;
    protected $type;

    protected $defaultColumns = [
        'Hosts.HostName AS "Host name"',
        'inventory_new.values->>\'OS\' as "OS"',
        'Hosts.IPAddress AS "IP address"',
        'Hosts.LastReportTimeStamp AS "Last report time"'
    ];

    public function __construct($conditionMustBeMet, $type)
    {
        $this->conditionMustBeMet = $conditionMustBeMet;
        $this->type = $type;
        $this->addResultColumn();
    }

    abstract public function getReportSql($sql, CF_Rule $rule);

    /**
     * @param $sql
     * @return string
     */
    protected function getFilter($sql, $joinInventory = false): string
    {
        $str = [];
        
        $str[] = "FULL OUTER JOIN ($sql) q2 ON q2.hostkey = Hosts.HostKey";

        if ($joinInventory) {
            $str[] = "LEFT JOIN inventory_new  ON Hosts.HostKey = inventory_new.hostkey";
        }
        
        if ($this->type !== self::ALL_TYPE) {
            $str[] = 'WHERE Hosts.HostKey ' . ($this->conditionMustBeMet ? 'NOT IN' : 'IN') . " ($sql)";
        }

        return implode(' ', $str);
    }
    
    /**
     * @return  void
     */
    protected function addResultColumn()
    {
        if ($this->type === self::ALL_TYPE) {
            if ($this->conditionMustBeMet) {
                $then = self::FAILING_TYPE;
                $else = self::PASSING_TYPE;
            } else {
                $then = self::PASSING_TYPE;
                $else = self::FAILING_TYPE;
            }
            array_unshift($this->defaultColumns, "CASE WHEN q2.hostkey IS NULL THEN '$then' ELSE '$else' END AS \"Compliance\"");
        } else {
            array_unshift($this->defaultColumns, "'$this->type' AS \"Compliance\"");
        }
    }
}
