#!/usr/bin/env bash
# Common setup for mission-portal CI tests
# This script should be sourced by test runner scripts

set -ex

# find the dir one level up from here, home of all the repositories
COMPUTED_ROOT=$(readlink -e $(dirname "$0")/../../)
# NTECH_ROOT should be the same, but if available use it so user can do their own thing.
NTECH_ROOT=${NTECH_ROOT:-$COMPUTED_ROOT}

"${NTECH_ROOT}/mission-portal/ci/check-environment.py"

USER=${USER:-$(whoami)}

mkdir -p "${NTECH_ROOT}/artifacts"

if [ ! -d /var/cfengine ]; then
  # ci and local buildscripts should place built packages in $NTECH_ROOT/artifacts
  set +e # to catch errors and copy appropriate logs to artifacts directory
  if ! sudo dpkg -i "$NTECH_ROOT"/artifacts/cfengine-nova-hub*deb; then
    tail /var/log/CFEngine-Install.log
    # github artifacts don't allow `:` in filenames which these install logs have, so put them in a tarball
    tar cfz "${NTECH_ROOT}/artifacts/install-logs.tgz" /var/log/CFEngine-Install-*.log
    tail /var/log/postgresql.log
    cp /var/log/postgresql.log "${NTECH_ROOT}/artifacts/"
    tail /var/cfengine/httpd/logs/error_log
    cp -a /var/cfengine/httpd/logs "${NTECH_ROOT}/artifacts/httpd-logs/"
    exit 1
  fi
  set -e # restore error handling
fi

# now that cfengine is probably installed, run cf-support if there is an error
trap failure ERR

function failure() {
  pwd
  ls -l
  sudo mkdir -p "${NTECH_ROOT}/artifacts"
  sudo chown $USER "${NTECH_ROOT}/artifacts"
  cd "${NTECH_ROOT}/artifacts"
  ( sudo cf-support --yes 2>&1; echo $? > /tmp/status ) > $$.cfsupportlog
  if [ "$(cat /tmp/status)" != "0" ]; then
    cat $$.cfsupportlog
  fi
  rm -f $$.cfsupportlog
}

if [ ! -f /var/cfengine/policy_server.dat ]; then
  sudo /var/cfengine/bin/cf-agent -B $(hostname -I | awk ' {print $1}')
fi

cd "$NTECH_ROOT"/mission-portal
sudo mkdir -p vendor
sudo chown -R cfapache vendor
# TODO FIXME, the below takes way too long
sudo chown -R cfapache . # brutal hammer, will take time but may make things "just work"
sudo touch composer.lock
sudo chown cfapache composer.lock
sudo -u cfapache /usr/local/bin/composer install
sudo cp -r /var/cfengine/httpd/htdocs/public/tmp ./public
sudo chown -R cfapache public
sudo cp -r /var/cfengine/httpd/htdocs/api .
sudo chown -R cfapache api
sudo cp -r /var/cfengine/httpd/htdocs/application/config/appsettings.php ./application/config/

sudo cp -f ./tests/mocks/sendmail /var/cfengine/bin/mock-sendmail
sudo chmod +x /var/cfengine/bin/mock-sendmail
sudo sed -i 's|^;sendmail_path =.*|sendmail_path = /var/cfengine/bin/mock-sendmail|' /var/cfengine/httpd/php/lib/php.ini

CF_MAIL_LOG_FILE="/var/log/sendmail.log"
if sudo test ! -f $CF_MAIL_LOG_FILE; then
  sudo touch $CF_MAIL_LOG_FILE
  sudo chmod 777 $CF_MAIL_LOG_FILE
else
  # reset logs
  sudo bash -c ": > $CF_MAIL_LOG_FILE"
fi

sudo apt install lsof -y
sudo lsof -i :9000 || true
sudo kill -9 $(sudo lsof -t -i :9000) || true

# restart cfengine3 services to apply php.ini changes
sudo /var/cfengine/httpd/bin/apachectl restart
sudo systemctl restart cfengine3

sudo systemctl stop cf-execd
sudo systemctl disable cf-execd
sudo systemctl stop cf-hub
sudo systemctl disable cf-hub

cd tests
sudo mkdir -p vendor
sudo chown cfapache vendor
sudo touch composer.lock
sudo chown cfapache composer.lock
sudo -u cfapache /usr/local/bin/composer update
mkdir -p /opt/cfengine/federation/cfapache/

# make artifacts directory for cfapache to write logs, screenshots, database dumps to
chown cfapache "${NTECH_ROOT}/artifacts"

# fixup system php.ini so that tests can create phar archives
sed -ri 's/^(\s|;)phar.readonly = On/phar.readonly = Off/' /etc/php/*/cli/php.ini

# add cfapache to sudoers with NOPASSWD: ALL so it can generate sql dumps with sudo -u cfpostgres
echo "cfapache ALL=(ALL) NOPASSWD: ALL" > /etc/sudoers.d/cfapache

"${NTECH_ROOT}/mission-portal/ci/http2check.sh"

# At this point we're in the tests directory and ready to run tests
