<?php
require_once APPPATH . 'libraries/Cf_REST_Controller.php';

class Cmdb extends Cf_REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('cmdb_model');
    }

    public function items_get($hostkey)
    {
        try {
            $limit = intval($_REQUEST['perPage'] ?? 6);
            $page = intval($_REQUEST['page'] ?? 1);
            $offset = ($page - 1) * $limit;
            $list = $this->cmdb_model->getItems($hostkey, $offset, $limit);
            $this->respond(200, json_encode($list));
            return;
        } catch (Exception $exception) {
            log_message('error', 'Unable to get cmdb list. Error: ' . $exception->getMessage());
            throw $exception;
        }
    }

    public function item_post($hostkey)
    {
        try {
            $data = json_decode($_REQUEST['data'], true);
            $list = $this->cmdb_model->createItem($hostkey, $data);
            $this->respond(200, json_encode($list));
            return;
        } catch (Exception $exception) {
            log_message('error', 'Unable to update cmdb. Error: ' . $exception->getMessage());
            throw $exception;
        }
    }

    public function item_put($id)
    {
        try {
            preg_match('/data=(.*)$/', $this->_put_args, $matches);
            $data = json_decode(urldecode($matches[1]), true);
            $list = $this->cmdb_model->updateItem($id, $data);
            $this->respond(200, json_encode($list));
            return;
        } catch (Exception $exception) {
            log_message('error', 'Unable to update cmdb. Error: ' . $exception->getMessage());
            throw $exception;
        }
    }

    public function item_get($hostkey, $type, $name)
    {
        try {
            $item = $this->cmdb_model->getItemByName($hostkey, $type, $name);
            $this->respond(200, $item);
            return;
        } catch (HttpClient_NotFound $exception) {
            $this->respond(404);
        } catch (Exception $exception) {
            log_message('error', 'Unable to get cmdb item. Error: ' . $exception->getMessage());
            throw $exception;
        }
    }

    public function item_delete($id)
    {
        try {
            $list = $this->cmdb_model->deleteItem($id);
            $this->respond(200, json_encode($list));
            return;
        } catch (Exception $exception) {
            log_message('error', 'Unable to delete cmdb item. Error: ' . $exception->getMessage());
            throw $exception;
        }
    }

    public function json_get($hostkey)
    {
        try {
            $json = $this->cmdb_model->getJSON($hostkey);
            $this->respond(200, $json);
            return;
        } catch (Exception $exception) {
            if ($exception instanceof HttpClient_NotFound) {
                $this->respond(404, "No data found for hostkey $hostkey");
            } else {
                log_message('error', 'Unable to get cmdb list. Error: ' . $exception->getMessage());
                throw $exception;
            }
        }
    }

    public function policy_configurations_ids_get($hostkey)
    {
        try {
            $ids = $this->cmdb_model->getPolicyConfigurationIds($hostkey);
            $this->respond(200, json_encode($ids));
            return;
        } catch (Exception $exception) {
            log_message('error', 'Unable to get policy configurations IDs. Error: ' . $exception->getMessage());
            throw $exception;
        }
    }
}
