<?php
/*

 This reports is used to show all available reports to user so user can subscribe to them

 */
?>

<div class="pageTitle">
    <h1>
        <span>Reports</span>
        <span class="pull-right">
            <i rel="tooltip" id="tab-context-help-icon" class="CFE-context-help help icon-question-sign" data-key="sql-reports" data-title="SQL reports" data data-placement='left' title="Click for help"> </i>
        </span>
    </h1>
</div>

<?php $this->load->view('/partials/_reports-speeddial'); ?>

<?php
//******************************* M O D A L *******************************************************
$this->load->view('/partials/_copySearchModal');
?>
<div class="row-fluid sql-result-table-wrapper">

    <div class="row-fluid float-left margin-bottom">
        <h3 class="inline">Other reports</h3>
        <a class="margin-left" ng-click="showOwnReports()">My saved reports</a>
    </div>


    <div class="row-fluid">
        <div class="span9 max-table">

            <?php $this->load->view('/partials/_notification'); ?>
            <div class="alert alert-warning" ng-show="!savedReports.length && reports_loaded">
                There are no saved reports in this category
            </div>

            <div ng-show="savedReports.length">
                <?php
                    $this->load->view('/partials/_pagination');
                ?>

                <table class="table table-horizontal margin-top float-left">
                    <thead>
                        <tr>
                            <th class="sort-head" ng-click="sortReorder('username_0', $event)">Author
                                <i ng-class="{'icon-chevron-up':VIEW.tablehead['username_0'].sort>0,'icon-chevron-down':VIEW.tablehead['username_0'].sort<0}"></i>
                            </th>
                            <th>Schedules</th>
                            <th class="sort-head" ng-click="sortReorder('label_1', $event)">Name
                                <i ng-class="{'icon-chevron-up':VIEW.tablehead['label_1'].sort>0,'icon-chevron-down':VIEW.tablehead['label_1'].sort<0}"></i>
                            </th>
                             <th class="sort-head" ng-click="sortReorder('reportCategory_2', $event)">Category
                                <i ng-class="{'icon-chevron-up':VIEW.tablehead['reportCategory_2'].sort<0,'icon-chevron-down':VIEW.tablehead['reportCategory_2'].sort>0}"></i>
                            </th>
                            <th colspan="3" class="actions right">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr ng-repeat="(rowid, row) in savedReports">
                            <td>
                                <span class="label label-user table-icon {{row.username}}">
                                    {{row.username}}
                                </span>
                            </td>
                            <td><span ng-show="row.hasSchedules == 1"><i class="icon-time no-hover"></i></span><span ng-show="row.showScheduleStatistic==1">(<span style="color: green">{{row.ownSchedules}}</span>/{{row.totalSchedules}})</span></td>
                            <td class="fill">
                                <a ng-if="row.reportCategory!='inventory' && row.reportCategory!='changes'" ng-href="report/run/{{row.id}}" ng-click="cleanStoredScope(); $event.stopPropagation()">{{row.label}}</a>
                                <a ng-if="row.reportCategory=='inventory'" ng-href="inventory/run/{{row.id}}" ng-click="cleanStoredScope(); $event.stopPropagation()">{{row.label}}</a>
                                <a ng-if="row.reportCategory=='changes'" ng-href="changes/run/{{row.id}}" ng-click="cleanStoredScope(); $event.stopPropagation()">{{row.label}}</a>
                            </td>
                            <td class="no-wrap">{{row.reportCategory | convertReportCategories}}</td>
                            <td class="no-wrap right actions">
                                <a ng-if="row.is_subscribed !=1 && row.can_subscribe == 1" class="" ng-click="cleanStoredScope(); subscribe(row.id)" href="javascript:void(0)">subscribe</a>
                                <a ng-if="row.is_subscribed ==1 && row.can_subscribe == 1" class="" ng-click="cleanStoredScope(); unsubscribe(row.id)" href="javascript:void(0)">unsubscribe</a>
                                <a class="delete" ng-click="cleanStoredScope(); setCurrentReportData(row.id, row.label, row.reportCategory); modalWindow.open('copySearchModal', this)" href="javascript:void(0)">copy</a>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <?php
                    $this->load->view('/partials/_pagination');
                ?>
            </div>
        </div>


        <div id="filter-sidebar" class="span3">
           <!-- <div id="">
                <h3>
                    Search
                </h3>
                <form class="form-search">
                    <input type="text" class=""  ng-change="" placeholder="Search reports...">
                </form>
            </div>-->
            <div id="categories">
                <h3 class="inline-block">Categories</h3>
                <a class="pull-right clearlink margin-top-small" ng-click="filterCategories()" href="javascript:void(0)">Clear all</a>
                <ul class="unstyled margin-bottom">
                  <li ng-repeat="category in reportCategories">
                      <div class="checkbox">
                        <label>
                          <input type="checkbox"
                            ng-click="filterCategories(category.value)"
                            ng-checked="isSelectedCategory(category.value)"
                          />
                          {{category.label}}
                      </label>
                    </div>
                  </li>
                </ul>
            </div>
        </div>

    </div>
</div>

<div class="clearfix"></div>
