(function($) {
    $.widget('ui.hostInfo', {
        options: {
            baseUrl: '',
            defaultbehaviour: true
        },
        header:$('<div class="header">'),
        _create: function() {
            var $self = this;

            $self.element.addClass('hostInfo');

            $self._values = {
                ip: $self._createValueElement(),
                osType: $self._createValueElement(),
                flavor: $self._createValueElement(),
                release: $self._createValueElement(),
                lastReportUpdate: $self._createValueElement(),
                lastPolicyUpdate: $self._createValueElement()
            };

            $self.element.append($self.header);
            //$self._colourIcon = $('<span>').addClass('colourIcon');
            //$self.header.append($self._colourIcon);

            $self._headerLabel = $('<a>').addClass('headerLabel');
            $self.header.append($self._headerLabel);

            var $column1 = $('<div>').addClass('column');
                $column1.append($self._createDivWrapper($self._createLabelElement('IP: '),$self._values.ip));
                $column1.append($self._createDivWrapper($self._createLabelElement('OS Type: '),$self._values.osType));
                $column1.append($self._createDivWrapper($self._createLabelElement('Flavor: '),$self._values.flavor));


            var $column2 = $('<div>').addClass('column');
                $column2.append($self._createDivWrapper($self._createLabelElement('Release: '),$self._values.release));
                $column2.append($self._createDivWrapper($self._createLabelElement('Last Report: '),$self._values.lastReportUpdate));
                $column2.append($self._createDivWrapper($self._createLabelElement('Policy Updated: '),$self._values.lastPolicyUpdate));


            $self.element.append($column1).append($column2);

            $.ui.hostInfo.instances.push($self.element);
        },

        _createDivWrapper:function(){
            var $element = $('<div>');
             for (var i = 0, j = arguments.length; i < j; i++){
               $element.append(arguments[i]);
             }
            return $element;
        },

        _createLabelElement: function(label) {
            var $element = $('<span class="width30 muted">');
            $element.html(label);
            return $element;
        },

        _createValueElement: function() {
            var $element = $('<span>');
            $element.html('&nbsp;');
            return $element;
        },

        _clearFields: function() {
            var $self = this;
            $self._headerLabel.html('');
            $self._values.ip.html('');
            $self._values.osType.html('');
            $self._values.flavor.html('');
            $self._values.release.html('');
            $self._values.lastReportUpdate.html('');
            $self._values.lastPolicyUpdate.html('');
        },

        _setHeader: function(hostkey, hostname, colour) {
            var $self = this;

            $self._headerLabel.html(hostname);
            $self._headerLabel.attr('href', $self._requestUrls.hostPage($self, hostkey));

        },

        updateHostKey: function(hostKey) {
            var $self = this;

            var requestUrl = $self.options.baseUrl + '/host/info/' + hostKey;
            $self._clearFields();
            $self._ajaxLoader.show($self);
            $.getJSON(requestUrl, function(host) {
                $self._setHeader(hostKey, host.hostname, host.colour);
                $self._values.ip.html(host.ip);

                if (host.OS)
                {
                    if (host.OS.Ostype !== undefined) {
                        $self._values.osType.html(host.OS.Ostype);
                    }
                    if (host.OS.Flavor !== undefined) {
                        $self._values.flavor.html(host.OS.Flavor);
                    }
                    if (host.OS.Release !== undefined) {
                        $self._values.release.html(host.OS.Release);
                    }
                }

                if (host.lastreport=== -1) {
                    $self._values.lastReportUpdate.html('never');
                }
                else if (host.lastreport !== undefined && host.lastreport >= 0) {
                    $self._values.lastReportUpdate.html(
                        common.time.format(common.unixTimeToJavascriptTime(host.lastreport)));
                }

                if (host.CFEngine && host.CFEngine["Last policy update"] !== undefined) {
                    // NOTE: lastPolicyUpdate is in text format
                    $self._values.lastPolicyUpdate.html(host.CFEngine["Last policy update"] + ' (agent timezone)');
                }
                $self._ajaxLoader.hide($self);
            }).fail(function(jqXHR, textStatus, errorThrown) {
                var opt = {
                    statusCode: jqXHR.status,
                    targetDiv: $self._headerLabel,
                    msg: jqXHR.responseText || null
                };
                common.showAjaxError(opt);
                $self._ajaxLoader.hide($self);
            }
            );
        },

        _ajaxLoader:{
           show:function($self){

            // show loader
                common.globalSpinner.show();
           },
           hide:function($self){
            // hide loader
               common.globalSpinner.hide();
           }

        },

        _requestUrls: {

            hostPage: function(self, key) {
                return self.options.baseUrl + '/hosts/' + key;
            }
        },

        destroy: function() {
            $.Widget.prototype.destroy.call(this);
        }
    });

    $.extend($.ui.hostInfo, {
        instances: []
    });
})(jQuery);
