<?php

class Notes extends Cf_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('note_model');
        $this->load->library('form_validation', 'Setting_lib');
        $this->form_validation->set_error_delimiters('<span class="errorlist">', '</span>');
    }

    function index()
    {

        $params = $this->uri->uri_to_assoc(3);
        $action = isset($params['action']) ? $params['action'] : "";
        $hostkey = isset($params['hostkey']) ? $params['hostkey'] : NULL;
        $this->data = array();
        $rid = isset($params['rid']) ? urldecode(($params['rid'])) : "";
        $reportType = isset($params['reporttype']) ? $params['reporttype'] : "";
        $hostKey = isset($params['hostkey']) ? $params['hostkey'] : "";
        $nid = isset($params['nid']) ? $params['nid'] : "";
        $username = $this->session->userdata('username');

        $this->data['nid'] = $nid;
        $this->data['rid'] = $rid;
        $this->data['hostkey'] = $hostKey;
        $this->data['reporttype'] = $reportType;

        if ($action == "show")
        {

            $filter = array('hostname' => $hostkey,
                'noteId' => $nid,
                'userId' => NULL,
                'dateFrom' => -1,
                'dateTo' => -1,
                'loggedUser' => $username
            );
            $this->data['data'] = $this->note_model->getAllNotes($filter);
            $this->data['form_url'] = site_url() . '/notes/addnote';
            $this->load->view('/notes/view_notes', $this->data);
        }
        else if ($action == "add")
        {
            $this->data['data'] = array();

            if (empty($nid))
            {
                $hasNotes = $this->note_model->hasNotes($hostKey);
                $this->data['nid'] = $hasNotes;
            }

            $this->data['form_url'] = site_url() . '/notes/addnote';
            $this->load->view('/notes/add_notes', $this->data);
        }
    }

    function addnote()
    {

        $nid = $this->input->post('nid') ? $this->input->post('nid') : null;
        $message = trim($this->input->post('Message'));
        $username = $this->session->userdata('username');
        $hostkey = $this->input->post('hostkey');
        $date = strtotime("now");
        $ret = false;
        $this->data['nid'] = $nid;
        $this->data['hostkey'] = $hostkey;
        $this->data['form_url'] = site_url() . '/notes/addnote';


        try
        {
            if (trim($message) != null && (strpos($message, '\\') === false))
            {
                $ret = $this->note_model->addNote($nid, $hostkey, $username, $date, $message);
                // return the same view with comments
                if (!$ret)
                {
                    $this->data['updateMessage'] = "Notes not added";
                }
                else
                {
                    $this->data['nid'] = $ret;
                    $this->data['successMessage'] = "Notes sucessfully added";
                }
            }
            else
            {
                $this->data['updateMessage'] = $this->lang->line('note_empty_insert');
            }
        }
        catch (Exception $e)
        {
            $this->data['updateMessage'] = "Something went wrong while adding notes." . $e->getMessage();
        }

        $this->load->view('/notes/add_notes', $this->data);
        return;
    }

    /**
     * generate parameters for pagination
     * @param type $filter
     */
    function generatePagingParams($filter)
    {
        $filterString = '';
        $pagingArray = array('userId', 'dateFrom', 'dateTo');
        foreach ($filter as $key => $value)
        {
            if (in_array($key, $pagingArray) && ($value != null))
            {
                $filterString .= '/' . $key . '/' . $value;
            }
        }
        return $filterString;
    }

}

?>
