<div ng-if="!isEmptyObj(savedConditions)" class="check-list-item" ng-repeat="(category, conditions) in savedConditions">
    <div class="check-list-item-category">{{category}}</div>
    <div>
        <table class="table fixed margin-top table-horizontal">
            <thead>
            <tr>
                <th>Name</th>
                <th>Description</th>
                <th>Severity level</th>
                <th>Actions</th>
            </tr>
            </thead>
            <tbody>
            <tr ng-repeat="(rowid, row) in conditions | orderBy: 'name'">
                <td>{{row.name}}</td>
                <td>{{row.description}}</td>
                <td>{{row.severity}}</td>
                <td>
                    <a ng-show="row.username == '<?= htmlspecialchars($this->username) ?>'"
                       add-edit-condition
                       source="instance"
                       dca="DCA"
                       show-add-button="show_add_form"
                       rules-list="rulesList"
                       rule-id="row.id">Edit
                    </a>
                    <a class="margin-left-small" ng-hide="editConditions" ng-click="removeCondition(row.id)">Remove</a>
                    <a class="margin-left-small" ng-show="editConditions" ng-click="deleteRuleEntity(row.id)">Delete</a>
                </td>
            </tr>
            </tbody>
        </table>
    </div>
</div>
