/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*global Class, MP_SITE_URL, angular*/
'use strict';

/*
 * Service for policy summary
 *
 **/


var policySummaryServiceClass = Class.extend({
    BASE_SQL: 'WITH promiseexecutions AS (' +
        '    SELECT' +
        '         promisehash, promiseoutcome, logmessages, policyfile, promisetype, bundlename, hostkey' +
        '    FROM   promiseexecutions )' +
        '    SELECT count(promisehash) as "Frequency", ' +
        '           promiseoutcome as "Promise outcome", ' +
        '           promisetype as "Promise type",' +
        '           bundlename as "Bundle name", ' +
        '           policyfile as "Policy file", ' +
        '           logmessages as "Log messages"' +
        '    FROM promiseexecutions',
    BASE_HASH_SQL: 'SELECT hosts.hostname as "Host name", promiseexecutions.promiseoutcome as "Promise outcome",promiseexecutions.promisetype as "Promise type",promiseexecutions.promiser as "Promiser",promiseexecutions.linenumber as "Line", CASE' +
        '    WHEN policyfilehash = \'SHA={0}\' THEN \'no\'' +
        '    ELSE \'yes\'' +
        '    END ' +
        '    AS   "Policy file version mismatch", ' +
        '    promiseexecutions.logmessages as "Log messages" ' +
        '    FROM "promiseexecutions" LEFT JOIN hosts ON hosts.hostkey = promiseexecutions.hostkey',

    getSql: function (filter) {

        if (!String.prototype.format) {
            String.prototype.format = function () {
                var args = arguments;
                return this.replace(/{(\d+)}/g, function (match, number) {
                    return typeof args[number] != 'undefined'
                        ? args[number]
                        : match
                        ;
                });
            };
        }

        let sql = '';

        if (filter.hash != undefined && filter.hash != false) {
            sql = this.BASE_HASH_SQL.format(filter.hash);
        } else {
            sql = this.BASE_SQL;
        }

        if (filter.inventory != undefined && filter.inventory.toString().length > 0) {
            sql += ' INNER JOIN inventory_cte ON inventory_cte.filtered_hostkey = promiseexecutions.hostkey';
        }

        let where = [];
        if (filter.relativeFilePath != undefined && filter.relativeFilePath.length > 0) {
            where.push("policyfile LIKE '%" + filter.relativeFilePath + "%'");
        }

        if (filter.dir != undefined && filter.dir.length > 0) {
            where.push("policyfile LIKE '%" + filter.dir + "%'");
        }

        if (filter.promiseOutcome != undefined && filter.promiseOutcome.length > 0) {
            where.push("promiseoutcome IN ('" + filter.promiseOutcome.join("','") + "')");
        }

        let whereSql = '';
        if (where.length > 0) {
            whereSql = ' WHERE ' + where.join(' AND ');
        }

        if (filter.hash != undefined && filter.hash != false) {
            sql = sql + whereSql;
        } else {
            sql = sql + whereSql + ' GROUP BY promisehash, promiseoutcome, policyfile, logmessages, promisetype, bundlename ORDER BY count(promisehash) DESC';
        }


        return sql;
    }
});

(function () {
    let policySummaryServiceProvider = Class.extend({
        instance: new policySummaryServiceClass(),
        $get: function () {
            return this.instance;
        }
    });

    angular.module('policySummaryServiceModule', [])
        .provider('policySummaryService', policySummaryServiceProvider);
}());