<?php

class EventsHandlerFactory
{
    /**
     * @param $type
     * @param $options
     * @return BaseEventHandler
     * @throws Exception
     */
    public function getHandler($type, $options)
    {
        try {
            $className = $this->decorateHandlerName($type) . 'Handler';
            $eventHandler = new $className($options);
        } catch (Exception $e) {
            throw new Exception('Event handler with type' . $type . ' not found.');
        }
        return $eventHandler;
    }

    private function decorateHandlerName($name)
    {
        $slices = explode('_', $name);
        array_map(function($value){
            return ucfirst($value);
        }, $slices);
        return implode('',$slices);
    }
}
