<div class="max-table">
    <h3 class="center margin-top-large" ng-show="!groups.length && groups_loaded">
        No groups found
    </h3>
    <div ng-show="groups.length">
        <table class="table table-horizontal listReports_SE margin-top float-left">
            <thead>
            <tr>
                <th ng-if="isShared(type)" class="fill sort-head"
                    ng-click="sortReorder('priority', !sort.descending)">
                    <i rel="tooltip" data-placement="bottom" data-original-title='Priority number used when merging data for hosts in multiple groups. Higher priority number is preferred.' style="margin-right: 0;" class="bi bi-arrow-down-up"></i>
                </th>
                <th class="fill sort-head" style="text-align: left" ng-click="sortReorder('name', !sort.descending)">
                    <i rel="tooltip" data-placement="bottom" data-original-title='Shared groups can be added to "My groups" by clicking the star next to the group name' class="bi bi-info-circle"></i> Group name
                    <i ng-class="{'icon-chevron-up': (sort.column == 'name' && sort.descending),'icon-chevron-down':  (sort.column == 'name' && !sort.descending)}"></i>
                </th>
                <th>Number of hosts
                    <i ng-class="{'icon-chevron-up': (sort.column == 'hosts_number' && sort.descending),'icon-chevron-down':  (sort.column == 'hosts_number' && !sort.descending)}"></i>
                </th>
                <th class="sort-head" ng-click="sortReorder('creation_time', !sort.descending)">Created at
                    <i ng-class="{'icon-chevron-up': (sort.column == 'creation_time' && sort.descending),'icon-chevron-down':  (sort.column == 'creation_time' && !sort.descending)}"></i>
                </th>
                <th class="sort-head" ng-click="sortReorder(isShared(type) ? 'creator' : 'owner', !sort.descending)">Created by
                    <i ng-class="{'icon-chevron-up': (sort.column == 'owner' && sort.descending),'icon-chevron-down':  (sort.column == 'owner' && !sort.descending)}"></i>
                </th>
                <th class="actions right"><span ng-if="!isShared(type)">Actions</span></th>
            </tr>
            </thead>
            <tbody class="groups-list_body_{{ type }}">
            <tr
                    title="{{ isShared(type) ? 'Drag to reorder: move down to increase priority.' : '' }}"
                    ng-repeat="group in groups track by group.id"
                    testforlast=""
                    data-group-priority="{{ group.priority }}"
                    data-id="{{ group.id }}"
            >
                <td ng-if="isShared(type)">
                    {{group.priority}}
                </td>
                <td style="text-align: left">
                    <i ng-if="!group.is_favorite && (isShared(group.type) || isShared(type))" ng-click="addFavorite(group.id, group.type || type)" title="Add to favorites"
                       class="bi bi-star"></i>
                    <i ng-if="group.is_favorite && (isShared(group.type) || isShared(type))" ng-click="removeFavorite(group.id, group.type || type)" title="Remove from favorites"
                       class="bi bi-star-fill"></i>
                    <a ng-if="!isShared(group.type) && !isShared(type)" style="margin-left: 26px" ng-href="{{group.type}}/{{group.id}}" ng-bind-html="group.name">{{ group.name }}</a>
                    <a ng-if="isShared(group.type) || isShared(type)" ng-href="./shared/{{group.id}}">{{group.name}}</a>
                    <div ng-if="isPersonal(group.type)" class="circle-outline">
                        <i
                       title="Personal group"
                       class="bi bi-person-fill"></i>
                    </div>
                    <div ng-if="isShared(group.type) && !group.has_data" class="circle-outline">
                        <i
                                title="Shared group"
                                class="group-shared-icon"></i>
                    </div>
                    <div ng-if="group.has_data" class="circle-outline">
                        <i
                                title="Shared group with data"
                       class="bi bi-braces"></i>
                    </div>

                </td>
                <td>{{ group.hosts_number }}</td>
                <td>{{formatTime(group.creation_time)}}</td>
                <td ng-bind-html="getUserName(group) | safe_html"></td>
                <td ng-if="!isShared(type)" class="actions no-wrap right">
                    <a ng-href="{{group.type}}/{{group.id}}">edit</a>
                    <a ng-click="duplicateGroup(group.id, 'personal', isShared(group.type))">duplicate</a>
                    <a ng-click="remove(group.id, group.name, isShared(group.type))" href="#">remove</a>
                </td>
                <td ng-if="isShared(type)" class="actions no-wrap">
                    <div class="btn-group no-btn pull-right actions-dots">
                        <a data-toggle="dropdown" class="btn no-btn dropdown-toggle">
                            <i class="bi bi-three-dots-vertical"></i>
                        </a>
                        <ul class="dropdown-menu">
                            <li><a ng-href="./shared/{{group.id}}">Edit</a></li>
                            <li><a ng-click="remove(group.id, group.name, true)">Remove</a></li>
                            <li><a ng-click="duplicateGroup(group.id, 'shared', true)">Duplicate</a></li>
                            <li class="divider"></li>
                            <li><b>Priority</b></li>
                            <li><a href="#" ng-class="{'dropdown-menu-select-disabled':group.priority === 1}"
                                   ng-click="(group.priority !== 1) && changePriority(group.id, 1)">Move to top
                                    (lowest priority)</a></li>
                            <li><a href="#" ng-class="{'dropdown-menu-select-disabled':group.priority === 1}"
                                   ng-click="(group.priority !== 1) && changePriority(group.id,group.priority - 1)">Move
                                    one up</a></li>
                            <li><a href="#"
                                   ng-class="{'dropdown-menu-select-disabled':group.priority === paginator.resultCount}"
                                   ng-click="(group.priority !== paginator.resultCount) && changePriority(group.id, -1)">Move
                                    to bottom (highest priority)</a></li>
                            <li><a href="#"
                                   ng-class="{'dropdown-menu-select-disabled':group.priority === paginator.resultCount}"
                                   ng-click="(group.priority !== paginator.resultCount) && changePriority(group.id, group.priority + 1)">Move
                                    one down</a></li>
                        </ul>
                    </div>
                </td>
            </tr>
            </tbody>
        </table>
        <div class="row-fluid float-left paginator_SE">
            <div class="span8">
                <div class="">
                    <form class="pull-left form-inline page-limit-selector" accept-charset="utf-8" method="post"
                          action="">
                        <span>Rows per page</span>
                        <span id="cfe-select-group-0" class="btn-group">
                    <button class="btn dropdown-toggle paginatorRowsPerPage_SE" data-toggle="dropdown">
                        {{paginator.rowsPerPage}}
                        <i class="bi bi-chevron-down"></i>
                    </button>
                    <ul class="dropdown-menu paginationRowsSelector_SE">
                        <li ng-repeat="item in paginator.rowsPerPageList">
                            <a ng-click="paginator.setRowsPerPage(item)" href="javascript:void(0)">{{item}}</a>
                        </li>
                    </ul>
                </span>
                    </form>
                </div>

                <div class="pagination inline-block"><p>{{paginator.getStartIndex()}}-{{paginator.getEndIndex()}} of
                        {{paginator.resultCount}}</p></div>
                <div class="pagination inline-block" ng-show="paginator.resultPagesList.length>0">
                    <ul class="pull-left">
                        <li ng-class="{'disabled': paginator.page == 1}">
                            <a ng-click="paginator.reloadView(1)" href="javascript:void(0)"><i
                                    class="bi bi-chevron-bar-left"></i></a>
                        </li>
                        <li ng-class="{'disabled': paginator.page  <= 1}">
                            <a ng-click="paginator.reloadView(paginator.page-1 || 1)" href="javascript:void(0)"><i
                                    class="bi bi-chevron-compact-left"></i></a>
                        </li>
                        <li ng-class="{'disabled': paginator.page >= paginator.pages}">
                            <a ng-click="paginator.reloadView(paginator.page+1 || paginator.pages)"
                               href="javascript:void(0)"><i class="bi bi-chevron-compact-right"></i></a>
                        </li>
                        <li ng-class="{'disabled': paginator.page == paginator.pages}">
                            <a ng-click="paginator.reloadView(paginator.pages)" href="javascript:void(0)"><i
                                    class="bi bi-chevron-bar-right"></i></a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div ng-show="groups && !groups.length">
        <h4 class="center margin-top-large">No groups found</h4>
    </div>
</div>

<script>
    $(document).ready(function () {
        $(".groups-list_body_shared").sortable({
            items: "tr",
            cursor: "move",
            opacity: 0.6,
            axis: "y",
            update: function (event) {
                angular.element(this).scope().onDrop(event.originalEvent.target.parentNode, angular.element(this).scope().changePriority);
            }
        });
    });
</script>
