angular.module('inventoryDirectives', [])
    .directive('inventoryfilter', ['$q', 'inventoryHelper', 'inventoryDataService', '$location', 'personalGroupsService', 'sharedGroupsService', 'inventoryFilterService',
    function ($q, inventoryHelper, inventoryDataService, $location, personalGroupsService, sharedGroupsService, inventoryFilterService) {
    return {
        restrict: 'C',
        link: function ($scope, $elm, $attrs) {
            // Handles a case when imported compliance checks contain not reported inventory attributes.
            // In this case they are missing type, which is required when editing a check.
            $scope.$watchCollection('[filters, ui.CFE_mapping]', (data) => {
                const [filters, CFE_mapping] = data;
                if (filters.length > 0 && Object.keys(CFE_mapping).length > 0) {
                    filters.forEach((filter, index) => {
                        if (filter.label != undefined && filter.type == undefined) {
                            for (const key in CFE_mapping) {
                                if (CFE_mapping[key].label == filter.label) {
                                    $scope.filters[index].type = CFE_mapping[key].type;
                                }
                            }
                        }
                    });
                }
            })
            new inventoryFilterDirectiveCtrl($scope, $elm, $attrs, $q, inventoryHelper, inventoryDataService, $location, personalGroupsService, sharedGroupsService, inventoryFilterService);

        },
        scope: {
            ui: '=',              // UI object
            sql: '=',              // SQL object
            readonly: '=',         // Readonly for alerts ui
            showfilterapplybtn: '=',
            applicationname: '=',    // small hack - set application name, and this will change app behaviour, For example for inventory alerts we need different select
            cfemappingaddfields: '=',
            cfemappingremovefields: '=',
            cfemappingaddtofilters: '=',
            includeClasses: '=',
            selectedGroup: '=',
            runReport: '=',
            showTop: '@',
        },
        templateUrl: MP_SITE_URL + '/directives/partials/directive_inventoryfilter.php'
    };
}]).filter('setDefaultConditionOption', function () {
    /**
     * Sets default condition option for filter
     *
     * @param {string} input - original value from model
     * @param {string} defaultVal - default value
     * @returns {string}
     */
    return function (input, defaultVal) {
        if (input)
            return input;
        else
            return defaultVal;
    };
}).filter('getLabelByValue', function () {
    return function (input, condition) {
        // return a filter condition from an array given a filter value
        var result = [];
        angular.forEach(input, function (val, key) {
            if (val.value === condition) {
                result.push(val);
                return;
            }
        });
        if (angular.equals([], result)) {
            result.push(input[0]);
        }
        return result;
    };
})
    .directive('inventoryFilterValidator', ['inventoryDataService', function (inventoryDataService) {
        return {
            require: 'ngModel',
            scope: {
                'validator': '&',
                'filter': '='
            },
            link: function (scope, elem, attr, ngModel) {
                ngModel.$parsers.unshift(function (value) {
                    scope.validator({form: ngModel, filter: scope.filter});
                    return value;
                });
            }
        };
    }]);
