'use strict';
/*
 * Service to controll notifications
 *
 error object looks like:

 obj[error_type]['errorCode'] = could be 404, 500 ..
 obj[error_type]['text']      = any text

 *
 */

dashboardApp.factory('notificationService', function($rootScope, $timeout) {
    var self = this;

    self.$timeout = $timeout;

    var $scope = {};
    $scope.notification = {};

    $rootScope.$on('modalClose', function() {
        self.notification.resetNotification();
    });

    $rootScope.$on('resetNotification', function() {
        self.notification.resetNotification();
    });

    $rootScope.$on('saveRule_Success_Event', function(event, data) {
        self.notification.setNotification('success', "The condition was saved successfully");
    });

    $rootScope.$on('saveAlert_Success_Event', function(event, data) {
        self.notification.setNotification('success', data);
    });

    $rootScope.$on('saveRule_Fail_Event', function(event, data) {
        self.notification.setNotification('error', data);
    });

    $rootScope.$on('getWidgets_Fail_Event', function(event, data) {
        self.notification.setNotification('error', data);
    });

    $rootScope.$on('getSingleWidgetFail_Event', function(event, data) {
        self.notification.setNotification('error', data);
    });
    $rootScope.$on('deleteWidget_Fail_Event', function(event, data) {
        self.notification.setNotification('error', data);
    });
    $rootScope.$on('deleteWidget_Success_Event', function(event, data) {
        self.notification.setNotification('success', "The widget was removed successfully");
    });

    $rootScope.$on('saveWidget_Fail_Event', function(event, data) {
        self.notification.setNotification('error', data);
    });

    $rootScope.$on('saveWidget_Success_Event', function(event) {
        self.notification.setNotification('success', "Widget saved");
    });

    $rootScope.$on('loadWidgetAlert_Fail_Event', function(event, data) {
        self.notification.setNotification('error', data);
    });

    $rootScope.$on('reorderWidgets_Fail_Event', function(event, data) {
        self.notification.setNotification('error', data);
    });

    $rootScope.$on('deleteRule_Fail_Event', function(event, data) {
        self.notification.setNotification('error', data);
    });

    $rootScope.$on('deleteRule_Success_Event', function(event) {
        self.notification.setNotification('success', "Successfully deleted");
    });

    $rootScope.$on('alertRulesList_Fail_Event', function(event, data) {
        self.notification.setNotification('warning', data);
    });

    $rootScope.$on('alertHosts_Fail_Event', function(event, data) {
        self.notification.setNotification('error', data);
    });

    $rootScope.$on('alertRuleGet_Fail_Event', function(event, data) {
        self.notification.setNotification('error', data);
    });

    $rootScope.$on('environmentProfileNotFound_Event', function(event, data) {
        self.notification.setNotification('error', data);
    });

    $rootScope.$on('saveAlert_Fail_Event', function(event, data) {
        self.notification.setNotification('error', data);
    });

    $rootScope.$on('deleteAlert_Fail_Event', function(event, data) {
        self.notification.setNotification('error', data);
    });

    $rootScope.$on('deleteAlert_Success_Event', function(event) {
        self.notification.setNotification('success', "The alert was removed successfully");
    });

    $rootScope.$on('hideNotification_Event', function() {
         $rootScope.$broadcast('hideNotification');
    });

    $rootScope.$on('getDashboards_Fail_Event', function(event, data) {
        self.notification.setNotification('error', data);
    });

    $rootScope.$on('saveDashboards_Fail_Event', function(event, data) {
        self.notification.setNotification('error', data);
    });

    self.notification = {
        getNotifications: function()
        {
            return $scope.notification;
        },
        /*This function will create error object. Use it for manual errors and warnings, errors from PHP already in the right format */
        createObjectForNotification: function(type, errorCode, text) {
            var error = {};

            error.type = $.trim(type) !== '' ? type : 'error';
            error.data = [];
            error.data[0] = {};
            error.data[0].text = $.trim(text) !== '' ? text : 'Query returned 0 rows';
            error.data[0].errorCode = errorCode !== '' ? errorCode : '555';
            return error;
        },
        setNotification: function(type, data, callbackFnc, callbackParams) {
            $scope.notification = {};
            $scope.notification[type] = {};
            //some workaround if error just a plain text, to make this compatible with all MP calls, like session expire
            if (angular.isArray(data))
            {
                $scope.notification[type].text = data[0].text;
                $scope.notification[type].errorCode = data[0].errorCode;
            }
            else
            {
                $scope.notification[type].text = data;
                $scope.notification[type].errorCode = 500;
            }
            $timeout(function() {
                $rootScope.$broadcast('setNotification');
            }, self.notification.notificationDelay);
        },
        resetNotification: function() {
            $scope.notification = {};
            $rootScope.$broadcast('resetNotificationMessage');
        }
    };
    return  self.notification;
});