import React, { useState } from 'react';

import {
    Dialog,
    DialogTitle,
    DialogContent,
    DialogActions,
    DialogContentText,
    IconButton,
    Box,
} from '@mui/material';

import {
    Close as CloseIcon
} from '@mui/icons-material';

interface CommonDialogProps {
    fullWidth?: boolean;
    open: boolean;
    title?: string;
    size?: 'xs' | 'sm' | 'md' | 'lg' | 'xl' | false;
    width?: number | null;
    className?: string;
    children: React.ReactNode;
    actionButtons?: React.ReactNode;
    onClose: () => void;
}

const CommonDialog: React.FC<CommonDialogProps> = ({
    fullWidth = false,
    open = false,
    onClose, title = '',
    size = 'md',
    className = '',
    width = null,
    children,
    actionButtons
}) => {
    const sx = width ? { '& .MuiDialog-paper': { width: width, maxWidth: width } } : {};
    return (
        <Dialog
            open={open}
            className={className}
            onClose={onClose}
            fullWidth={fullWidth}
            maxWidth={size}
            sx={sx}
        >
            <DialogTitle
                sx={{
                    display: 'flex',
                    alignItems: 'center',
                    justifyContent: 'space-between'
                }}
            >
                <Box>
                    {title}
                </Box>
                <IconButton aria-label="close" onClick={onClose}>
                    <CloseIcon />
                </IconButton>
            </DialogTitle>
            <DialogContent>
                {children}
            </DialogContent>
            <DialogActions sx={{ px: 3, pb: 2 }}>
                {actionButtons}
            </DialogActions>
        </Dialog>
    );
};

export default CommonDialog;
