<aside>
    <a href="/build/project/{{ projectID }}" class=""><div class="logo"></div></a>
    <div class="empty-project" ng-if="project.is_local">
        <i class="bi bi-exclamation-circle-fill"></i>
        <div>
            <div>
                You have not set up a remote repository for your "{{ project.name }}".
                The changes you make will not be synchronized or backed up anywhere.
            </div>
            <a class="btn btn-info" href="/build/project/edit/{{ projectID }}">
                Set repository
            </a>
        </div>
    </div>
    <div class="project-name">
        <div>Project</div> <a href="/build/project/edit/{{ projectID }}">Edit</a>
    </div>
        <div class="controls">
            <select ng-if="data.projects.length > 0"
                    select-project
                    data-placeholder="Select project"
                    ng-model="data.selectedProject"
                    watch="data.projects"
                    ng-options="project.id as project.name for project in data.projects track by project.id"
                    class="chosen-dropdown"
            ></select>
        </div>
    <div class="added-modules">
        <h4>Added modules</h4>
        <div class="added-modules_empty" ng-hide="addedModules.length">There are no modules in your CFEngine Build project</div>
        <div ng-show="addedModules.length">
            <ul>
                <li ng-repeat="module in addedModules" ng-class="{selected: moduleName == module.name && !(module.isExternal && instance == 'modulesPageController')}">
                    <a ng-if="module.isExternal" title="{{ module.name.length > 22 ? module.name : '' }}" href="/build/external/modules/{{ module.encodedName }}">{{ module.name }}</a>
                    <a ng-if="!module.isExternal" title="{{ module.name.length > 22 ? module.name : '' }}" href="/build/modules/{{ module.name }}">{{ module.name }}</a>
                    <i ng-show="(module.version != module.availableVersion) && !module.isExternal" title="update available" class="bi bi-info-circle-fill"></i>
                    <i ng-if="module.isExternal" title="This module is not from the canonical index, build.cfengine.com." class="bi bi-briefcase-fill"></i>
                </li>
            </ul>
        </div>
    </div>
</aside>
