<script type="text/ng-template" id="addDashboard.html">
    <div class="modal-header">
        <button type="button" class="close" ng-click="close('addDashboard');"><i class="bi bi-x"></i></button>
        <h2 ng-show="dashData.id===undefined">Create new dashboard</h2>
        <h2 ng-show="dashData.id!==undefined">Edit dashboard</h2>
    </div>
    <div class="modal-body">
        <div id="notification_block_wrapper" data-notifications></div>
        <div class="row-fluid">
            <form enter-press="createDashboard()" class='form-horizontal'>
                <div class='control-group'>
                    <div class='control-label'>
                        <label>Dashboard name</label>
                    </div>
                    <div class='controls'><input id="widget-name" type='text' ng-model='dashData.name' maxlength='100' placeholder='Name'>
                        <p class='help-block'>Choose a unique name for the dashboard.</p>
                    </div>
                </div>

                <div class='control-group' ng-hide="dashData.id!==undefined">
                    <div class='control-label'>
                        <label>Start with</label>
                    </div>
                    <div class='controls' ng-init="dashData.starting=true">
                        <div class="radio margin-bottom-small"><label><input type="radio" name="starting" ng-model="dashData.starting" value=true ng-checked="true">Default widgets</label></div>
                        <div class="radio"><label><input type="radio" name="starting" ng-model="dashData.starting" value=false>Empty dashboard</label></div>
                    </div>
                </div>

                  <div class='control-group'>
                    <div class='control-label'>
                        <label>Share dashboard</label>
                    </div>
                      <div class='controls'>
                          <div class="checkbox">
                              <input type='checkbox' ng-model='isChecked'
                                     ng-change="dashData.public = isChecked ? '1' : '0';"
                                     ng-click="$event.stopPropagation();">
                          </div>
                          <p class='help-block'>Allow other users to view, but not edit, your dashboard.</p>
                          <div class="unstyled" ng-if="dashData.public">
                              <div>
                                  <label> Share with users:
                                      <div style="position: relative">
                                          <select multiple
                                                  chosen
                                                  data-placeholder="Select users"
                                                  ng-model="shared.users.selectedOptions"
                                                  watch="shared.users.options"
                                                  ng-options="item.name group by item.type for item in shared.users.options track by item.id"
                                          >
                                          </select>
                                      </div>
                                  </label>
                              </div>
                              <div class="margin-top">
                                  <label>Share with users that belong to roles:
                                      <div style="position: relative">
                                          <select multiple
                                                  chosen
                                                  data-placeholder="Select roles"
                                                  ng-model="shared.roles.selectedOptions"
                                                  watch="shared.roles.options"
                                                  ng-options="item.name group by item.type for item in shared.roles.options track by item.id"
                                          >
                                          </select>
                                      </div>
                                  </label>
                              </div>
                          </div>
                      </div>
                  </div>
            </form>
        </div>
    </div>
    <div class="modal-footer">
        <a class="btn btn-large" ng-click="modalWindow.close('addDashboard');" href="javascript:void(0)">Cancel</a>
        <button id="continue" class="btn btn-large btn-primary" ng-click="createDashboard(dashData.id!==undefined)">Save</button>
    </div>
</script>

<style>
    .modal-body, .modal.fade {overflow: visible}
</style>
