 <div class="margin-top-small">

        <p id="noArchivesWarning" class="alert alert-info nn-margin"><em>There are currently no archives ready for download. We need to collect a full month of data first.</em></p>

        <table id="analyticsDownloadsTable" class="table no-margin">
        <?php if(!empty($archive)) { ?>
        <?php foreach($archive as $db) { ?>
            <tr>
                <td width="85%"><strong><?php echo date("F Y", $db['timestamp']); echo $debug ? " <em>(". htmlspecialchars($db['uid']).")</em>" : "" ?></strong></td>
                <td width="5%">
                    <button class="btn btn-large btn-danger delete<?php echo $db['downloads']>0 ? "" : " hide"?>" data-uid="<?= htmlspecialchars($db['uid']) ?>">Delete</button>
                </td>
                <td width="10%">
                    <button class="btn btn-large download" data-uid="<?= htmlspecialchars($db['uid']) ?>">Download</button>
                </td>
            </tr>
        <?php   } ?>
        <?php } ?>
        </table>

        <!-- Alerts -->
        <div class="modal hide fade" id="modalConfirm" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" >
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" ><i class="bi bi-x"></i></button>
            <h2>Delete Data?</h2>
        </div>
        <div class="modal-body">
            <p>Sending analytics data to feedback@cfengine.com will help us improve CFEngine's user experience and get the coming releases even closer to what our users need.</p>
			<p>Are you sure you want to delete the data?</p>
        </div>
        <div class="modal-footer">
            <button class="btn" data-dismiss="modal" >Close</button>
            <button class="btn btn-primary saveBtn">Ok</button>
        </div>
        </div>
 </div>

<script type="text/javascript">
    $(document).ready(function(){

        <?php if(!empty($archive)) { ?>
                $('#noArchivesWarning').hide();
        <?php } ?>

        var baseUrl = "<?php echo site_url(); ?>";
        var domain = baseUrl + "/analytics/";

        $('.btn[data-toggle=button]').button('toggle');
        $('.btn-group.btn').on('click', function (e) {
            $(this).addClass('btn-primary').siblings().removeClass('btn-primary');
        });

        $('.btn.download').on('click', function (e) {
            e.preventDefault();
            var downloadButton = $(this).parent().parent().children('td').children('.btn.delete:hidden');
            $(downloadButton).show('slide',{ direction: "right" },300, function() { $(this).show(); });
            window.location.href = domain+"download/"+$(this).attr('data-uid');
            //window.open(domain+"download/"+$(this).attr('data-uid'));
        });

        $('.btn.delete').on('click', function (e) {
            var that = this;
            e.preventDefault();

            $('#modalConfirm').modal().on("click", ".saveBtn", function(event){
                event.preventDefault();
                $('#modalConfirm').modal('hide');

                $.ajax({
                    type: "GET",
                    url: domain+"delete/"+$(that).attr('data-uid'),
                    success: function(response){
                        $(that).closest('tr').fadeOut(300, function() {
                            $(this).remove().ready(function() {
                               if($("#analyticsDownloadsTable tr").length==0)
                                $('#noArchivesWarning').show();

                            });
                        });
                    }
                });
            });
        });
    });
</script>
