<div class="row-fluid">
    <div class="span12">
        <div class="span3">
            <div class="cf-sidenav cf-sidenav-tree">
                <ul class="nav nav-list">
                    <li class="active">
                        <a href="#"><i class="icon-caret-right"></i>Models</a>
                            <ul>
                                <li><a href="#">All promises</a></li>
                                <li><a href="#">PCI</a></li>
                                <li><a href="#">STIGS</li>
                            </ul>
                    </li>

                     <li>
                        <a href="#"><i class="icon-caret-right"></i>Locations</a>
                            <ul>
                                <li><a href="#">London</a></li>
                                <li><a href="#">New York</a></li>
                                <li><a href="#">Oslo</a></li>
                            </ul>
                    </li>

                </ul>
            </div>

        </div>

        <div class="span9">
            <div class="row-fluid" style="height:20px;background: #f6f6f6">

            </div>
            <div class="row-fluid">
                <div class="tabbable"> <!-- Only required for left/right tabs -->
                    <ul class="nav nav-tabs">
                        <li class="active"><a href="#tab1" data-toggle="tab">Compliance</a></li>
                        <li><a href="#tab2" data-toggle="tab">Overview</a></li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                            <div id="compliance" class="row-fluid">
                                <h6><?php echo $this->lang->line('compliance_summary_graph_title') ?></h6>
                                <div id="environment-list">
                                    <ul class="nav nav-tabs">
                                        <li class="selected"><span class="front"></span><a class ="updateComplianceGraph" href="<?php echo site_url(); ?>/welcome/getJsonComplianceSummary/" title="">Default</a><span class="rear"></span>
                                        </li>
                                        <?php
                                        foreach ($envList as $key => $env)
                                        {
                                            ?>
                                            <li><span class="front"></span><a class ="updateComplianceGraph" href="<?php echo site_url(); ?>/welcome/getJsonComplianceSummary/<?= htmlspecialchars($env) ?>" title="environment_<?= htmlspecialchars($env) ?>"><?= htmlspecialchars($env) ?></a><span class="rear"></span></li>
                                        <?php } ?>
                                    </ul>
                                </div>
                                <div id="compliancemeter" style="padding:5px;">
                                    <div id="compliance_summary_graph" style="height: 200px; width:95%;"></div>
                                </div>
                            </div>
                            <div class="row-fluid">
                                <div class="well">
                                    <p>
                                        RFC! This app is currently in an early stage of specification, and currently
                                        only supports an overview of total promise compliance for this hub, which
                                        was formerly on the status page of CFEngine Nova editions.

                                        This app shows the compliance of the system according to different
                                        regulatory models, geographies and host classes (left hand navigation
                                        panel.). Compliance is defined as a measure of the number of promises
                                        that are kept across the IT infrastructure.

                                        We would welcome your ideas and feedback to contact@cfengine.com.

                                    </p>
                                </div>
                            </div>



                        </div>
                        <div class="tab-pane" id="tab2">
                            <div id="business-value-pie-chart-container" class="span6">
                                <h6 class="text-centered"><?php echo $this->lang->line('business-value-pie-chart-container_title'); ?></h6>
                                <div id="business-value-pie-chart" style="height: 120px;width:300px;margin-left: 120px;">
                                </div>
                            </div>
                            <div id="compliance-value-pie-chart-container" class="span6">
                                <h6 class="text-centered"><?php echo $this->lang->line('compliance-value-pie-chart-container_title'); ?></h6>
                                <div  id="compliance-now-pie-chart" style="height: 120px; width:300px; margin-left: 120px;">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
        </div>

    </div>
</div>
<script type="text/javascript">
    // for summary compliance graph

    var d1 = <?php echo $compliance_summary['graphSeries']['keptseries']; ?>;

    var d2 = <?php echo $compliance_summary['graphSeries']['repairedseries']; ?>;

    var d3 = <?php echo $compliance_summary['graphSeries']['notkeptseries']; ?>;
    var d4 = <?php echo $compliance_summary['graphSeries']['nodataseries']; ?>;



    var countTrack = <?php echo $compliance_summary['graphSeries']['count']; ?>;
    var graphEnvironment = '';


    var startData = [
        {   //first series
            label:"Kept",
            data: d1

        },
        {   //second series
            label:"Repaired",
            data: d2

        },
        {   //3rd series
            label:"Notkept",
            data: d3

        },
        {   //4th series
            label:"No data",
            data: d4

        }
    ];



    var options = {
        series: {
            stack: false,
            bars: { show: true,lineWidth:0, barWidth: 18000000,fill:1,align:'center' },
            lines: {show:false,fill:false,steps: false,lineWidth:0},
            shadowSize:  0
        },
        legend: {
            show: false
        },
        xaxis: {
            color:'#000',
            mode: "time",
            timeformat: "%b-%d",
            minTickSize: [1, "day"]
        },
        yaxis: {
            show: false,
            max:110
        },

        grid: {     hoverable: true,
            clickable: true,
            autoHighlight: true,
            color: '#CCC',
            borderWidth: 1
        },
        colors: ["#779a62", "#F0d76a", "#cc4358","#000000"]
    };
    var plot = $.plot($("#compliance_summary_graph"), startData,options );




    var previousPoint = {point:null,sIndex:null};
    $("#compliance_summary_graph").on("plothover", function (event, pos, item) {
        $("#x").text(pos.x.toFixed(2));
        $("#y").text(pos.y.toFixed(2));


        if (item) {
            if (previousPoint == null || previousPoint.point != item.dataIndex || previousPoint.sIndex != item.seriesIndex ) {
                previousPoint.point = item.dataIndex;
                previousPoint.sIndex = item.seriesIndex;

                $(this).css('cursor','pointer');
                plot.highlight(item.series, item.datapoint,event);

                $("#tooltip").remove();
                var x = item.datapoint[0].toFixed(2),
                y = item.datapoint[1].toFixed(2);
                var actualvalue = item.series.data[item.dataIndex][1];
                var startTime = (item.datapoint[0]);

                var startDate = new Date(startTime );
                var start = startDate.getHours() + ':00';
                var stopDate = new Date(startDate);
                stopDate.setHours(stopDate.getHours() + 6);
                var stop =stopDate.getHours() + ':00';
                var key =  startTime /1000;

                var c = countTrack[key];


                var tooltip = item.series.label + " : "+ actualvalue + '<br /> Local time : ' + start + '-' + stop
                    + ' <br />Count : ' + c;
                showTooltip(item.pageX, item.pageY,tooltip);

            }
        }
        else {
            $(this).css('cursor','default');
            $("#tooltip").remove();
            plot.unhighlight();
            previousPoint.point = null;
            previousPoint.sIndex = null;
        }

    });


    $("#compliance_summary_graph").on("plotclick", function (event, pos, item) {
        if (item) {
            var start = (item.datapoint[0] );
            var startDate = new Date(start );
            var start = startDate.getHours() + ':00';
            var stopDate = new Date(startDate);
            stopDate.setHours(stopDate.getHours() + 6);
            var stop =stopDate.getHours() + ':00';
            var sendDate = item.datapoint[0] /1000;
            var element = $('<a href="<?php echo site_url(); ?>/widget/summaryCompliance/start/'+ sendDate + '/env/' + graphEnvironment+ '" title="Overview : Promises not kept or repaired ( '+ start + ' - ' + stop + ' )" />');
            var option = {'width':'1025','height':'445'};
            element.ajaxyDialog(option).ajaxyDialog("open");
        }
    });



    $('.updateComplianceGraph').click(function(){
        var url = $(this).attr('href');
        var env = $(this).attr('title');
        $(this).parent().siblings(".selected").removeClass("selected").find('.tippointer').remove();
        $(this).parent().addClass('selected');
        $('<div class="tippointer">').css({'margin-top':5,'left':$(this).parent().width()/2 -6}).appendTo($(this).parent());

        $.getJSON(url, function(data) {

            var json = data.graphdata;
            // update count and start track as well
            countTrack =  data.countData;

            //update the graph environment variable
            graphEnvironment = env;

            $.plot($("#compliance_summary_graph"), json,options );
        });
        return false;
    });


    var businessValueData =  [
        { label: "Kept",  data: <?php echo $businessValuePie['kept']; ?>,color:"#779a62"},
        { label: "Not kept",  data: <?php echo $businessValuePie['notkept']; ?>,color:"#CC4358"},
        { label: "Repaired",  data: <?php echo $businessValuePie['repaired']; ?>,color:"#F0D76A"},
        { label: "No data",  data: <?php echo $businessValuePie['nodata']; ?>,color:"#000000"}
    ];

    $.plot($("#business-value-pie-chart"), businessValueData,
    {
        series: {
            pie: {
                show: true,
                radius: 0.7,
                tilt: 0.3,
                label: {
                    show: false
                },
                highlight: {
                    opacity: .5
                }
            }
        },
        legend: {
            show: false
        },grid: {
            hoverable: true,
            clickable: true
        }

    });


    var complianceNowData =  [
        { label: "Green",  data: <?php echo $greenhost; ?>,color:"#779a62"},
        { label: "Yellow",  data: <?php echo $yellowhost; ?>,color:"#F0D76A"},
        { label: "Red",  data: <?php echo $redhost; ?>,color:"#CC4358"},
        { label: "Blue",  data: <?php echo $bluehost; ?>,color:"#476E8C"},
        { label: "Black",  data: <?php echo $blackhost; ?>,color:"#000000"}
    ];
    $.plot($("#compliance-now-pie-chart"), complianceNowData,
    {
        series: {
            pie: {
                show: true,
                radius: 0.7,
                tilt: 0.3,
                label: {
                    show: false
                },
                highlight: {
                    opacity: .5
                }
            }
        },
        legend: {
            show: false
        },grid: {
            hoverable: true,
            clickable: true
        }

    });

    var previousPointBusinessValue = {'val':null};
    var previousPointComplianceNow = {'val':null};
    $("#business-value-pie-chart").on("plothover",{'unit':'mu','previousPoint':previousPointBusinessValue},pieHover);
    $("#compliance-now-pie-chart").on("plothover",{'unit':'host','previousPoint':previousPointComplianceNow}, pieHover);

    $($("#compliance-now-pie-chart")).on('mouseout', function() {
        plot.unhighlight();
        $("#tooltip").remove();
        $(this).data('previous-post', -1);
    });
    var previousPost = null;
    function pieHover(event, pos, item)
    {

        if (item) {
            if ($(this).data('previous-post') != item.seriesIndex) {
                plot.unhighlight();
                plot.highlight(item.series, item.datapoint);
                $(this).data('previous-post', item.seriesIndex);
            } else return ;
            $("#tooltip").remove();
            var  percent = parseFloat(item.series.percent).toFixed(2);
            var index = item.dataIndex;
            var value = item.series.data[index][1];
            var content = '<span>'+item.series.label+' ('+percent+'%) <br /> Value: '+value+' '+event.data.unit+' '+ '</span>';
            showTooltip(pos.pageX, pos.pageY, content);
        } else {
            plot.unhighlight();
            $("#tooltip").remove();
            previousPost = $(this).data('previous-post', -1);
        }
    }




    function showTooltip(x, y, contents) {
        var toolTipContent='<div class="tooltip-arrow"></div><div class="tooltip-inner">'+contents+'</div></div>';
        $('<div id="tooltip">' + toolTipContent + '</div>').addClass('tooltip top in').css( {
            top: y-70,
            left: x-70,
            opacity: 0.65
        }).appendTo("body").fadeIn(100);
    }




</script>
