<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Login extends cf_base_controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->library(array('form_validation'));
        $this->lang->load('cf_message');
        //list of errors wrapped in <p> class of errors
        $this->form_validation->set_error_delimiters('<span class="errorlist">', '</span>');
        //$this->load->database();
        $this->load->helper('url');
        $this->config->load('ion_auth', TRUE);
        $this->load->model('ProfileModel');
        $this->load->model('reset_password_model');
        $this->load->model('setup_model');
        
        if (!$this->setup_model->isSetupComplete()) {
            redirect('setup', 'refresh');
            exit;
        }


        $js = [
            ['dist/cfengine.bundle.js'],
            ['showPassword.js']
        ];
        
        // remove the 2FaCode cookie that can be left from the previous session
        delete_cookie('2FaCode');
        $this->carabiner->js(dev_file: $js, prod_file: $js, combine: true, minify: false, group: 'login');
    }

    //log the user out
    function logout()
    {
        $this->session->unset_userdata("defaultadmin");
        $this->data['title'] = "Logout";

        try
        {

            $logout = $this->ion_auth->logout();
        }
        catch(Exception $e)
        {
            log_message(log_level_for_exception($e),'Error login out user. '.$e->getMessage());
        }

        if(isset($_COOKIE['profileToLoad'])){
            setcookie('profileToLoad', '', time() - 3600, '/');
        }

        //redirect them back to the page they came from
        redirect('login/index', 'refresh');
    }

    //log the user in
    function index()
    {
        $this->data['title'] = "Login";
        $identifier = $this->config->item('identity', 'ion_auth');
        //validate form input
        if ($identifier == "username")
            $this->form_validation->set_rules('username', 'Username', 'required');
        else
            $this->form_validation->set_rules('email', 'Email Address', 'required|valid_email');

        $this->form_validation->set_rules('password', 'Password', 'required');
        $this->form_validation->set_rules('twoFaCode', 'twoFaCode', 'xss_clean');

        if ($this->form_validation->run() == false) {
            //the user is not logging in so display the login page
            //set the flash data error message if there is one
            $this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');

            $this->data['lbl_identifier'] = "Username";
            $this->data['identifier'] = array('name' => 'username',
                'id' => 'username',
                'type' => 'text',
                'value' => $this->session->flashdata('username'),
            );

            $this->data['twoFa'] = $this->session->flashdata('show2fa') ? [
                'name' => 'twoFaCode',
                'id' => 'twoFaCode',
                'type' => 'text',
                'autofocus' => 'autofocus',
                'placeholder' => 'xxxxxx',
                'maxlength' => '6'
            ] : null;

            $this->data['password'] = array('name' => 'password',
                'id' => 'password',
                'type' => 'password',
                'value' => $this->session->flashdata('password'),
            );

            $this->data['timezone'] = array('name' => 'timezone',
                'id' => 'timezone',
                'type' => 'hidden',
            );
            $this->data['remember'] = $this->session->flashdata('remember');
            $this->load->model('customization_model');
            $this->data = array_merge($this->data, $this->customization_model->getSettings());

            $this->load->view('auth/login', $this->data);
            return;
        }
            $twoFaPresented = $this->input->post('twoFaCode') !== null;
            $remember = (bool) $this->input->post('remember');
            // add a session variable for the timezone information of the user for date conversion
            $this->session->set_userdata('user_timezone', $this->input->post('timezone'));

            if ($this->ion_auth->login(trim($this->input->post($identifier)), $this->input->post('password'), $remember, $this->input->post('twoFaCode')))
            {
                $this->session->set_flashdata('password', $this->input->post('password'));
                $this->session->set_flashdata('twoFaCode', $this->input->post('twoFaCode'));
                
                $this->session->set_userdata('securitySettings', json_encode($this->setting_lib->getSecuritySettings()));

                // If login was successful, but credentials are admin/admin:
                if ($this->input->post($identifier)=="admin" && $this->input->post('password')=="admin" && $this->session->userdata('firstLogin')) {
                    $this->session->set_userdata(['defaultadmin' => true]);
                    redirect('login/change_default', 'refresh');
                } elseif ($this->ProfileModel->getAdditionalData($this->input->post($identifier), ProfileModel::FIRST_lOGIN_AFTER_RESET_KEY) === 'true') {
                    $this->session->set_userdata(['show2fa' => $twoFaPresented]);
                    redirect('login/change_default', 'refresh');
                } else {
                    $this->session->set_flashdata('message', array('type'=>'alert-error','content'=>$this->ion_auth->errors()));
                    if(!empty(get_cookie('url_to_redirect_after_login')))
                    {
                        $url = get_cookie('url_to_redirect_after_login');
                        delete_cookie('url_to_redirect_after_login');
                        redirect($url, 'refresh');
                    }
                    redirect('welcome/index', 'refresh');
                }
            }
            else { //if the login was unsuccessful
                $twoFaFailed = str_contains($this->ion_auth->errors(), Ion_auth::TWO_FACTOR_UNSUCCESSFUL_ERROR);
                if ($twoFaFailed && $twoFaPresented) {
                    // if the unsuccessful login had twoFaCode and its failed then 
                    // keep showing 2FA code input and error about not valid code
                    $this->session->set_flashdata('show2fa', true);
                    $this->session->set_flashdata('message', array('type'=>'alert-error','content'=> '2FA code is incorrect.'));
                } elseif ($twoFaFailed) {
                    // show 2FA code input, but not display error if the previous login was not with twoFaCode
                    $this->session->set_flashdata('show2fa', true);
                } else  {
                    //redirect them back to the login page
                    $this->session->set_flashdata('message', array('type'=>'alert-error','content'=> $this->ion_auth->errors())); 
                }
                
                $this->session->set_flashdata($identifier, $this->input->post($identifier));
                $this->session->set_flashdata('password', $this->input->post('password'));
                $this->session->set_flashdata('remember', $remember);
                redirect('login/index', 'refresh'); //use redirects instead of loading views for compatibility with MY_Controller libraries
            }

    }

    public function forgot_password()
    {
        $this->data['title'] = "Forgot password";
        $this->form_validation->set_rules('username', 'Username', 'required');

        if (!$this->form_validation->run()) {
            if (validation_errors()) {
                $this->data['message'] = validation_errors();
            }
            $this->data['username'] = $this->form_validation->set_value('username');
            $this->load->view('auth/forgot_password', $this->data);
        } else {
            $result = $this->reset_password_model->requestResetLink($this->input->post('username'));
            if ($result['success']) {
                redirect('auth/reset-password/confirm', 'refresh');
            } else {
                $this->data['message'] = array('type' => 'alert-error', 'content' => $result['message']);
                $this->data['username'] = $this->form_validation->set_value('username');
                $this->load->view('auth/forgot_password', $this->data);
            }
        }
    }

    public function reset_password()
    {
        $this->data['title'] = "Reset password";
        $token = $this->input->get('token');
        if ($token !== null) {
            $result = $this->reset_password_model->resetPasswordByToken($token);
            if (isset($result['tokenNotFound']) && $result['tokenNotFound']) {
                $this->data['message'] = array('type' => 'alert-error', 'content' => $result['message']);
                $this->data['token'] = $token;
                $this->load->view('auth/reset_password', $this->data);
            } else {
                redirect('auth/reset-password/change?token=' . $token);
            }
        } else {
            $this->load->view('auth/reset_password', $this->data);
        }
    }

    public function change_password_by_reset_token()
    {
        $js = [['changePassword.js']];
        $this->carabiner->js(dev_file: $js, prod_file: $js, combine: true, minify: true, group: 'change_password');
        
        $this->data = [
            'title' => 'Reset password',
            'token' => $this->input->get('token'),
            'minPasswordLength' => Settings_rest_model::DEFAULT_FIELDS[Settings_rest_model::MIN_PASSWORD_LENGTH],
            'passwordComplexity' => Settings_rest_model::DEFAULT_FIELDS[Settings_rest_model::PASSWORD_COMPLEXITY],
        ];

        // the same url used to view form and change password
        // is_ajax() means update action
        if (is_ajax()) {
            $token = $this->input->get('token');
            $result = $this->reset_password_model->resetPasswordByToken($token, $this->input->post('new'));

            if ($result['success']) {
                $data['status'] = 'password-reset-completed';
            } else {
                $data['message']['alert-error'] = $result['message'];
            }
            respond_ok(json_encode($data));
            return;
        }
        
        $this->load->view('auth/change_password_by_reset_token', $this->data);
    }
    
    public function reset_password_invalidate(): void
    {
        $this->data['title'] = "Invalidate reset password token";
        $token = $this->input->get('token');
        if ($token) {
            $result = $this->reset_password_model->invalidateResetPasswordToken($token);
            if ($result['success']) {
                $this->data['topMessage'] = '<i class="bi bi-check-circle green"></i> Your password reset token has been successfully invalidated';
            } else {
                $this->data['message'] = array('type' => 'alert-error', 'content' => $result['message']);
            }
        } else {
            $this->data['message'] = array('type' => 'alert-error', 'content' => 'Reset password token is required.');
        }
        
        $this->load->view('auth/auth_messages', $this->data);
    }
    
    function change_default()
    {
        $js = [['changePassword.js']];
        $this->carabiner->js(dev_file: $js, prod_file: $js, combine: true, minify: true, group: 'login');
        if ($this->session->userdata('securitySettings')) {
            $securitySettings = json_decode($this->session->userdata('securitySettings'), $associative = true);
        } else {
            /**
             * fallback values that UI will use in case of missing security settings pre-set on the login step
             * even if default values will be different from what is saved, backend will perform validation anyway.
             */
            $securitySettings = [
                'minPasswordLength' => 8,
                'passwordComplexity' => 3
            ];
        }
        $this->data = [...$securitySettings];

        $this->data[ProfileModel::FIRST_lOGIN_AFTER_RESET_KEY] = $this->ProfileModel->getAdditionalData($this->session->userdata('username'), ProfileModel::FIRST_lOGIN_AFTER_RESET_KEY) === 'true';
        $this->data['show2fa'] = $this->session->userdata('show2fa');
        $this->data['twoFaCode'] = $this->session->userdata('twoFaCode');
        $this->data['old'] = $this->session->userdata('password');
        if (
            $this->session->userdata("defaultadmin") ||
            $this->data[ProfileModel::FIRST_lOGIN_AFTER_RESET_KEY]
        )
        {
            $this->data['title'] = "Change default password";
            $this->data['explanation'] = $this->data[ProfileModel::FIRST_lOGIN_AFTER_RESET_KEY] ? $this->lang->line('change_reset_password') : $this->lang->line('default_admin_password_change');
            $this->load->view('auth/change_default', $this->data);
        }
        else
        {
            redirect("welcome/index", 'refresh');
        }


    }

}
