<?php

class Favourite_reports_model extends Cf_Model
{
    const TABLE = 'favourite_reports';

    public function add(string $username, int $reportId) : int
    {
        $data = [
            'username' => $username,
            'report_id' => $reportId
        ];

        $this->db->insert(self::TABLE, $data);
        return $this->db->insert_id();
    }

    public function delete(string $username, int $reportId)
    {
        $this->db->delete(self::TABLE, ['report_id' => $reportId, 'username' => $username]);
    }

    public function list(string $username): array
    {
        return array_map(
            function ($row) {
                return $row['report_id'];
            },
            $this->db->select('report_id')->where('username', $username)->get(self::TABLE)->result_array()
        );
    }
}
