<?php
class Personal_groups_model extends Cf_Model
{
    private $endpoint = '/host-groups/personal';
    private $myGroupsEndpoint = '/host-groups/my';

    public function create($data)
    {
        return $this->getRestClient()->post($this->endpoint, $data);
    }

    public function update($id, $data)
    {
        return $this->getRestClient()->patch("{$this->endpoint}/$id", $data);
    }

    public function makeShared($id)
    {
        return $this->getRestClient()->post("{$this->endpoint}/$id/share");
    }

    public function remove($id)
    {
        return $this->getRestClient()->delete("{$this->endpoint}/$id");
    }

    public function get($id)
    {
        return $this->getRestClient()->get("{$this->endpoint}/$id");
    }

    public function list($params)
    {
        $query = http_build_query($params);
        return $this->getRestClient()->get("{$this->myGroupsEndpoint}?$query");
    }

    public function personalGroupsList($params)
    {
        $query = http_build_query($params);
        return $this->getRestClient()->get("{$this->endpoint}?$query");
    }

    public function addToFavorites($id)
    {
        return $this->getRestClient()->post("{$this->endpoint}/$id/favorite");
    }

    public function removeFromFavorites($id)
    {
        return $this->getRestClient()->delete("{$this->endpoint}/$id/favorite");
    }
}
