<?php

class Widget extends Cf_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model(array('host_model', 'class_model', 'report_model', 'bundle_model', 'promise_model'));
        if (!$this->ion_auth->logged_in())
        {
            respond_unauthorized($this->lang->line('session_expired'));
            exit;
        }
    }

    function allclasses($page = 1, $alphaSearch = null, $limit = 100)
    {
        $limit = intval($limit);
        $username = $this->session->userdata('username');

        $searchletter = null;

        if ($alphaSearch != null)
        {
            $searchletter = urldecode($alphaSearch);
        }
        else
        {
            $searchletter = '.*';
        }


        $includes = $excludes = array();

        if ($this->input->post('includes') !== FALSE)
        {
            $includes = array_merge($includes, $this->input->post('includes', TRUE) ?? []);
        }

        if ($this->input->post('excludes') !== FALSE)
        {
            $excludes = $this->input->post('excludes', TRUE);
        }

        try
        {
            $classes = $this->class_model->getAllClasses($username, $searchletter, $includes, $excludes, $limit, $page);
            $result = json_encode($classes);
            respond_ok($result);
        }
        catch (Exception $e)
        {
            respond_internal_error($e->getMessage(), $e->getMessage());
        }
    }


    function allpolicies($page = 1)
    {
        try
        {
            $returnedData = array();

            $showButton = $this->input->post('showButton');
            $showOnlyHandle = trim($this->input->post('showOnlyHandle')) === 'false' ? false : true;
            $showOnlyBundle = trim($this->input->post('showOnlyBundle')) === 'false' ? false : true;



            $viewdata = array(
                'title' => $this->lang->line('mission_portal_title') . " - " . $this->lang->line('breadcrumb_report'),
                'showButton' => $showButton,
                'showOnlyHandle' => $showOnlyHandle,
                'showOnlyBundle' => $showOnlyBundle
            );

            if ($showOnlyBundle === true)
            {
                $temp = $this->bundle_model->getAllBundles($this->session->userdata('username'));
                $offset = ($page - 1) * 50;
                if (!empty($temp))
                {
                    $data = array();
                    foreach ($temp as $item)
                    {
                        $data[] = $item[1]; // $item[1] - bundle name 0 is type
                    }
                    $temp = $data;
                    $returnedData = array_slice($temp, $offset, 50);
                }
            }
            else
            {
                $returnedData = $this->promise_model->getPromiseListByHandleRx($this->session->userdata('username'), NULL, 50, $page);
            }

            $viewdata['viewdata']['data'] = $returnedData;
            $this->load->view('widgets/allpolicies', $viewdata);
        }
        catch (Exception $e)
        {
            show_error_custom($e->getMessage());
        }
    }

    function search_by_handle($page = 1)
    {
        $handle = $this->input->post('filter');
        $showButton = $this->input->post('showButton');
        $showOnlyHandle = trim($this->input->post('showOnlyHandle')) === 'false' ? false : true;
        $showOnlyBundle = trim($this->input->post('showOnlyBundle')) === 'false' ? false : true;


        $viewdata = array(
            'title' => $this->lang->line('mission_portal_title') . " - " . $this->lang->line('breadcrumb_report'),
            'showButton' => $showButton,
            'showOnlyHandle' => $showOnlyHandle,
            'showOnlyBundle' => $showOnlyBundle
        );

        if (empty($handle))
        {
            $handle = '.*';
        }  else if ($handle[0] != '^')
        {
            // if it is anchored regex search eveywhere
            $handle = '.*' .$handle .'.*';
        } else
        {
            $handle = $handle .'.*';
        }

        try
        {
            $returnedData = $this->promise_model->getPromiseListByHandleRx($this->session->userdata('username'), $handle, 50, $page);
            $viewdata['viewdata']['data'] = $returnedData;
            $this->load->view('widgets/allpolicies', $viewdata);
        }
        catch (Exception $e)
        {
            show_error_custom($e->getMessage());
        }
    }

    function search_by_bundle($page = 1)
    {
        $returnedData = array();

        $bundle = $this->input->post('filter');
        $showButton = $this->input->post('showButton');
        $showOnlyHandle = trim($this->input->post('showOnlyHandle')) === 'false' ? false : true;
        $showOnlyBundle = trim($this->input->post('showOnlyBundle')) === 'false' ? false : true;


        $viewdata = array(
            'title' => $this->lang->line('mission_portal_title') . " - " . $this->lang->line('breadcrumb_report'),
            'showButton' => $showButton,
            'showOnlyHandle' => $showOnlyHandle,
            'showOnlyBundle' => $showOnlyBundle
        );

        $data = "";
        $bundle = ($bundle) ? $bundle . '.*' : NULL;
        try
        {
            //format the returned data so there are only unique handles in the array.
            if ($showOnlyBundle === true)
            {
                $temp = $this->bundle_model->getAllBundles($this->session->userdata('username'));
                if (!empty($temp) && is_array($temp))
                {
                    $data = array();
                    $offset = ($page - 1) * 50;
                    foreach ($temp as $item)
                    {
                        $data[] = $item[1]; // $item[1] - bundle name 0 is type
                    }
                    //filter the bundles list on supplied filter
                    $temp = preg_grep("/" . $bundle . "/", $data);
                    $returnedData = array_slice($temp, $offset, 50);
                }
            }
            else
            {
                $returnedData['data'] = $this->promise_model->getPromiseListByBundleRx($this->session->userdata('username'), '.*', $bundle, 50, $page);
            }
            //return item as paged as no paging backed funtionality is there for listing bundles
            $viewdata['viewdata'] = $returnedData;
            $this->load->view('widgets/allpolicies', $viewdata);
        }
        catch (Exception $e)
        {
            show_error_custom($e->getMessage());
        }
    }

    function search_by_bundle_type($page = 1)
    {
        $val = $this->input->post('filter');
        $type = $this->input->post('type');
        $showButton = $this->input->post('showButton');
        $showOnlyHandle = trim($this->input->post('showOnlyHandle')) === 'false' ? false : true;
        $showOnlyBundle = trim($this->input->post('showOnlyBundle')) === 'false' ? false : true;
        $viewdata = array(
            'title' => $this->lang->line('mission_portal_title') . " - " . $this->lang->line('breadcrumb_report'),
            'showButton' => $showButton,
            'showOnlyHandle' => $showOnlyHandle,
            'showOnlyBundle' => $showOnlyBundle
        );


        try
        {
            $val = ($val) ? $val . '.*' : ".*";
            $promises = $this->promise_model->getPromiseListByBundleRx($this->session->userdata('username'), $val, null, 100, $page);
            $viewdata['viewdata']['data'] = $promises;
            $this->load->view('widgets/allpolicies', $viewdata);
        }
        catch (Exception $e)
        {
            show_error_custom($e->getMessage());
        }
    }

    function search_by_promiser($page = 1)
    {
        $promiser = $this->input->post('filter');
        $showButton = $this->input->post('showButton');
        $showOnlyHandle = trim($this->input->post('showOnlyHandle')) === 'false' ? false : true;
        $showOnlyBundle = trim($this->input->post('showOnlyBundle')) === 'false' ? false : true;
        $viewdata = array(
            'title' => $this->lang->line('mission_portal_title') . " - " . $this->lang->line('breadcrumb_report'),
            'showButton' => $showButton,
            'showOnlyHandle' => $showOnlyHandle,
            'showOnlyBundle' => $showOnlyBundle
        );
        try
        {
            $promiser = ($promiser) ? $promiser . '.*' : null;
            $returnedData = $this->promise_model->getPromiseListByPromiserRx($this->session->userdata('username'), $promiser, 100, $page);
            $viewdata['viewdata']['data'] = $returnedData;
            $this->load->view('widgets/allpolicies', $viewdata);
        }
        catch (Exception $e)
        {
            show_error_custom($e->getMessage());
        }
    }

    function astrolabeAddNodeDialog($label = NULL, $class = NULL)
    {
        $data['label'] = $label;
        $data['class'] = $class;

        $this->load->view('widgets/astrolabeAddNodeDialog', $data);
    }

    function astrolabeAddTreeDialog()
    {
        $data['isAdmin'] = $this->ion_auth->is_admin();
        try
        {
            $rolesList = $this->ion_auth->get_roles();
            $roles = array();
            foreach ((array) $rolesList as $r)
            {
                $roles[] = $r['id'];
            }
            $data['roles'] = $roles;
        }
        catch (HttpClient_Forbidden $e)
        {
            // if error listing roles just list the roles the use currently has
            $data['roles'] = $this->session->userdata('roles') ? $this->session->userdata('roles') : array();
        }

        $this->load->view('widgets/astrolabeAddTreeDialog', $data);
    }

    function astrolabeEditTreeDialog($id = null)
    {
        $this->load->model('Astrolabe_Model');
        $data['isAdmin'] = $this->ion_auth->is_admin();
        if (empty($id))
        {
            respond_internal_error("No id given");
        }


        $data['editMode'] = true;
        $username = $this->session->userdata('username');
        $treeProfile = $this->Astrolabe_Model->profile_get($username, $id);
        if (empty($treeProfile))
        {
            respond_internal_error("Cannot find tree profile to edit with id $id");
        }
        try
        {
            $rolesList = $this->ion_auth->get_roles();
            $roles = array();
            foreach ((array) $rolesList as $r)
            {
                $roles[] = $r['id'];
            }
            $data['roles'] = $roles;
        }
        catch (HttpClient_Forbidden $e)
        {
            // if error listing roles just list the roles the use currently has
            $data['roles'] = $this->session->userdata('roles') ? $this->session->userdata('roles') : array();
        }
        $data['selectedRoles'] = !empty($treeProfile->sharedPermission) && is_array($treeProfile->sharedPermission) ? $treeProfile->sharedPermission : array();
        $data['globalTree'] = !empty($treeProfile->global) ? $treeProfile->global : false;
        $data['treename'] = $treeProfile->profileId;
        $this->load->view('widgets/astrolabeAddTreeDialog', $data);
    }

    function astrolabeSubscribeTreeDialog()
    {
        $username = $this->session->userdata('username');
        $roles = $this->session->userdata('roles') ? $this->session->userdata('roles') : array();
        $this->load->model('Astrolabe_Model');
        $data = array();
        $data['treeList'] = $this->Astrolabe_Model->subscription_get($username, $roles);
        $this->load->view('widgets/astrolabeSubscribeTree', $data);
    }

    function contextfinder()
    {
        $data = array();

        if ($this->input->post('html_id') !== FALSE)
        {
            $data['html_id'] = $this->input->post('html_id', TRUE);
        }

        if ($this->input->post('doNotShowButtons') !== FALSE)
        {
            if (strtolower($this->input->post('doNotShowButtons', TRUE)) == 'false' || $this->input->post('doNotShowButtons', TRUE) == '')
                $data['doNotShowButtons'] = false;
            else
                $data['doNotShowButtons'] = true;
        }

        if ($this->input->post('embedded') !== FALSE)
        {
            if (strtolower($this->input->post('emdedded', TRUE)) == 'false' || $this->input->post('emdedded', TRUE) == '')
                $data['embedded'] = false;
            else
                $data['embedded'] = true;
        }

        if ($this->input->post('include_field_name') !== FALSE)
        {
            $data['include_field_name'] = $this->input->post('include_field_name', TRUE);
        }

        if ($this->input->post('includes') !== FALSE)
        {
            $data['fields']['left']['values'] = $this->input->post('includes');
        }

        if ($this->input->post('exclude_field_name') !== FALSE)
        {
            $data['include_field_name'] = $this->input->post('include_field_name', TRUE);
        }

        if ($this->input->post('excludes') !== FALSE)
        {
            $data['fields']['right']['values'] = $this->input->post('excludes');
        }

        $this->load->view('widgets/contextfinder', $data);
    }
}
