<?php

class SettingsAuthenticationExporter extends BaseDataExporter
{
    public function isOnlyForAdmin(): bool
    {
        return true;
    }

    public function getData(): array
    {
        $ldapConfigName = 'settings.ldap.php';
        $ldapConfig = FCPATH . 'ldap/config/' . $ldapConfigName;
        if (file_exists($ldapConfig)) {
            $content = file_get_contents($ldapConfig);
            $encryptedContent = $this->ci->cf_encrypt->encryptByKey($content, $this->encryptionKey);
            $this->phar->addFromString($ldapConfigName, $encryptedContent);
        }

        return ['data' => $ldapConfigName, 'info' => 'yes'];
    }
}
