/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*global Class, MP_SITE_URL, angular*/
'use strict';

/*
 * Service for dataTransfer
 *
 **/


var DataTransferServiceClass = Class.extend({
    MODULE_URL: MP_SITE_URL + '/data_transfer/api',

    export: function (data, exportOnlyUserItems, encryptionKey) {
        let params = {"items[]": data, exportOnlyUserItems: exportOnlyUserItems, encryptionKey: encryptionKey};
        var url = this.MODULE_URL + '/export';
        return this.$http({
            method: 'GET',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: url,
            params: params,
            cache: false
        });
    },

    makeImport: function (data) {
        var url = this.MODULE_URL + '/import';
        return this.$http({
            method: 'POST',
            headers: {'Content-Type': undefined},
            url: url,
            data: data,
            transformRequest: angular.identity
        });
    },

    getExportItems: function () {
        var url = this.MODULE_URL + '/exportItems';
        return this.$http({
            method: 'GET',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
            },
            url: url,
            cache: false
        });
    },

    analyzeImportFile: function (data) {
        var url = this.MODULE_URL + '/analyzeImportFile';
        return this.$http({
            method: 'POST',
            headers: {'Content-Type': undefined},
            url: url,
            data: data,
            transformRequest: angular.identity
        });
    },

});

(function () {
    var dataTransferServiceProvider = Class.extend({
        instance: new DataTransferServiceClass(),
        $get: ['$http', function ($http) {
            this.instance.$http = $http;
            return this.instance;
        }]
    });

    angular.module('dataTransferServiceModule', [])
        .provider('dataTransferService', dataTransferServiceProvider);
}());