'use strict';

let modulesListController = BaseBuildController.extend({
  init: function ($scope, modulesService, projectsService, $routeParams, $modal) {
    this._super($scope, projectsService, $routeParams, $modal);

    this.modulesService = modulesService;

    $scope.pagination = {
      perPage: 10,
      page: 1,
      maxPage: 1,
      total: 0,
      startItemIndex: 0,
      endItemIndex: 0
    };

    $scope.RELEVANCE = 'Relevance';
    $scope.ALPHABETICALLY = 'Alphabetically';
    $scope.MOST_DOWNLOADS = 'Most downloads';
    $scope.MOST_RECENT = 'Most recent';

    $scope.params = { sortColumn: 'name', sortDescending: 'false' };
    $scope.order = {
      list: [$scope.ALPHABETICALLY, $scope.RELEVANCE, $scope.MOST_DOWNLOADS, $scope.MOST_RECENT],
      by: $scope.ALPHABETICALLY
    };

    if ($routeParams.hasOwnProperty('query') && $routeParams.query.length > 0) {
      $scope.params.searchQuery = $routeParams.query;
      $scope.order.by = $scope.RELEVANCE;
    }

    $scope.rowsPerPageList = [5, 10, 25, 50, 100];
    $scope.modules = [];
  },

  defineListeners: function () {
    this._super();
    let self = this;

    this.$scope.$watchCollection('[pagination.perPage, pagination.page]', () => {
      this.$scope.params = {
        ...this.$scope.params,
        ...{
          limit: this.$scope.pagination.perPage,
          skip: (this.$scope.pagination.page - 1) * this.$scope.pagination.perPage
        }
      };
      calcPaginationData();
    });

    this.$scope.$watch(
      'params',
      params => {
        common.globalSpinner.show();
        this.modulesService.getList(params).then(
          r => {
            this.$scope.pagination.total = r.data.meta.total;
            this.$scope.modules = r.data.data.map(item => {
              item.updated = new Date(item.updated).toLocaleString('default', {
                month: 'short',
                day: 'numeric',
                year: 'numeric'
              });
              return item;
            });
            common.globalSpinner.hide();
          },
          error => {
            notify.error(error.data);
            common.globalSpinner.hide();
          }
        );
      },
      true
    );

    this.$scope.$watch('pagination.total', () => calcPaginationData());
    this.$scope.$watch('pagination.perPage', () => (this.$scope.pagination.page = 1));

    this.$scope.$watch('order.by', orderBy => {
      self.$scope.params.sortDescending = 'true';
      switch (orderBy) {
        case self.$scope.ALPHABETICALLY:
          self.$scope.params.sortColumn = 'name';
          self.$scope.params.sortDescending = 'false';
          break;
        case self.$scope.RELEVANCE:
          self.$scope.params.sortColumn = 'relevance';
          break;
        case self.$scope.MOST_DOWNLOADS:
          self.$scope.params.sortColumn = 'downloads';
          break;
        case self.$scope.MOST_RECENT:
          self.$scope.params.sortColumn = 'updated';
          break;
      }
    });

    const calcPaginationData = () => {
      this.$scope.pagination.startItemIndex = this.$scope.pagination.total > 0 ? this.$scope.params.skip + 1 : 0;
      this.$scope.pagination.maxPage = Math.ceil(this.$scope.pagination.total / this.$scope.pagination.perPage);
      this.$scope.pagination.endItemIndex =
        this.$scope.pagination.startItemIndex + this.$scope.pagination.perPage > this.$scope.pagination.total
          ? this.$scope.pagination.total
          : this.$scope.pagination.startItemIndex + this.$scope.pagination.perPage - 1;
    };
  },

  defineScope: function () {
    this.$scope.instance = 'modulesListController';
  }
});

modulesListController.$inject = ['$scope', 'modulesService', 'projectsService', '$routeParams', '$modal'];
