import React from 'react';

import ContentCopyIcon from '@mui/icons-material/ContentPaste';
import { Box, Typography } from '@mui/material';

import { useNotify } from '../notify';
import { useValidateStyles } from '../styles';

interface CodeDisplayProps {
  command: string;
}

export const CodeDisplay: React.FC<CodeDisplayProps> = ({ command }) => {
  const { classes } = useValidateStyles();
  const { success: notifySuccess } = useNotify();

  const copyToClipboard = (text: string) => {
    navigator.clipboard.writeText(text);
    notifySuccess('Copied.');
  };

  return (
    <Box className="margin-top instructions">
      <Typography component="strong">Don&#39;t have your setup code?</Typography>
      <Typography>To get a new setup code, run the following command on your hub.</Typography>
      <Box component="pre" className={classes.codeBlock}>
        <Typography component="code" className={classes.codeText}>
          {command}
        </Typography>
        <ContentCopyIcon className={classes.copyIcon} onClick={() => copyToClipboard(command)} fontSize="small" />
      </Box>
      <Typography className="note">Note: The setup code will expire after 1 hour</Typography>
    </Box>
  );
};
