<?php

class Docs extends Cf_Controller
{

    private $username = "";

    function __construct()
    {
        parent::__construct();
        $this->username = $this->session->userdata('username');

        setCurrentApplication('docs');
    }

    function index($document = NULL)
    {
        if ($document == NULL)
        {
            redirect('docs/cf3-bestpractice.html');
        }

        $data = array(
            'title' => $this->lang->line('mission_portal_title') . " - " . $this->lang->line('docs'),
            'title_header' => "Docs",
        );

        $root = getcwd();

        $root = $root . '/docs/';

        try
        {
            $data['docs'] = $this->knowledge_model->listDocuments($root);
            $data['documentToLoad'] = $document;

            $documentSegment = explode('#', $document);
            $fileInfo = pathinfo($documentSegment[0]);


            if (count($documentSegment) > 1)
            {
                $data['documentSegementToLoad'] = $documentSegment[1];
            }

            if ($fileInfo['extension'] == 'html')
            {
                $htmlData = @file_get_contents($root . $documentSegment[0]);
                if ($htmlData !== false)
                {
                    $pos_start = stripos($htmlData, '<body>');
                    if ($pos_start !== false)
                    {
                        $pos_end = stripos($htmlData, '</body>');
                    }
                    if ($pos_start !== false && $pos_end !== false)
                    {
                        $res = substr($htmlData, $pos_start + 7, $pos_end - $pos_start);
                    }
                    //replace the image name with full path in every image tag.
                    $res = preg_replace('/(<img src=")(.*)("\s+.*>)/i', '${1}' . base_url() . 'docs/${2}' . '${3}', $res);

                    $data['document'] = $res;
                }
                else
                {
                    $data['document'] = null;
                }
            }
            else
            {
                $data['document'] = '<img src="' . base_url() . '/docs/' . $documentSegment[0] . '" />';
            }
        }
        catch (Exception $e)
        {
            show_error($e->getMessage(), 500);
        }

        $data['class_active'] = "docs";
        $data['mainDataContent'] = $this->load->view('docs', $data, true);
        $this->template->load('template', 'index', $data);
    }

    function help()
    {
        $data = array(
            'title' => $this->lang->line('mission_portal_title') . " - " . $this->lang->line('docs'),
            'title_header' => "Help",
        );

        $data['mainDataContent'] = $this->load->view('contexthelp/inline-help-manual', $data, true);
        $this->template->load('template','contexthelp/inline-help-manual', $data);
    }

    public function extra($file)
    {
        if (!file_exists(FCPATH . '/application/views/extraDocs/' . $file)) {
            respond_not_found();
            exit;
        }

        $name = extractHtmlFileName($file);
        $data = array(
            'title'        => $this->lang->line('mission_portal_title') . " - " . $name,
            'title_header' => $name,
        );

        $this->template->load('template', 'extraDocs/' . urldecode($file), $data);
    }

}
