'use strict';

dashboardApp.directive('inventoryWidget', ['inventoryWidgetHelper', '$q', function (inventoryWidgetHelper) {
    return {
        templateUrl: MP_SITE_URL + '/dashboard/partials/inventory_widget',
        restrict: 'A',
        scope: {
            widget: '=',
            currentUser: "=",
            inventoryVariable: "=",
            currentDash: "=",
            saveOldName: '&',
            editName: '&',
            deleteWidget: '&',

        },
        link: function (scope, element) {
            var helper = inventoryWidgetHelper;
            scope.$watch(function () {
                return element.attr('refresh');
            }, function () {
                helper.getInventoryStats({"attributeName": scope.widget.payload.inventoryAttribute, type: scope.widget.payload.chartType}).then(
                    function (result) {
                        let chartList = helper.getChartData(scope.widget.payload, result);
                        // if there are no data then set legend and series to false to prevent displaying an empty chart
                        if (result.data.length == 0) {
                            chartList.legend = false;
                            chartList.series = false;
                        }
                        scope.widget.chartList = chartList;
                    }
                );
            });


        }
    };

}]);

dashboardApp.directive('inventoryTable', ['$q', function () {
    return {
        templateUrl: MP_SITE_URL + '/dashboard/partials/table_widget',
        restrict: 'A',
        scope: {
            config: '='
        }
    };
}]);
