/*jslint node: true */
/*jslint browser: true*/
/*jslint nomen: true*/
/*jslint es6: true */
/*global Class, MP_SITE_URL, angular*/
'use strict';

const userServiceClass = Class.extend({
    DASHBOARDAPI_URL: MP_SITE_URL + '/dashboard/dashboardsapi',
    getUsers: function () {
        return this.$http.get(`${this.DASHBOARDAPI_URL}/users`, {cache: false});
    },
    getRoles: function () {
        return this.$http.get(`${this.DASHBOARDAPI_URL}/roles`, {cache: false});
    }
});

(function () {
    const userServiceProvider = Class.extend({
        instance: new userServiceClass(),
        $get: ['$http', function ($http) {
            this.instance.$http = $http;
            return this.instance;
        }]
    });

    angular.module('userServiceModule', []).provider('userService', userServiceProvider);
}());
