policyAnalyzerApp.directive('policyEditor', function () {
    return {
        templateUrl: MP_SITE_URL + '/policy/analyzer/partials/policyEditor',
        restrict: 'A',
        scope: {
            fileContents: '=',
            file: '=?',
            policyLineSelected: '=?',
            policiesInfo: '=?'
        },

        link: function ($scope, element, attr) {

            ace.config.set('modePath', '/scripts/node_modules/ace-builds/src-min-noconflict');
            ace.config.set('useWorker', false); // only disables syntax checking which as a read-only editor we don't need
            var editor = ace.edit('editor');
            var markers = [];
            editor.session.setMode("ace/mode/perl");

            const setTheme = () => {
                editor.setTheme(
                    $('body').hasClass('dark') ?
                        "ace/theme/tomorrow_night" :
                        "ace/theme/github"
                );
            };
            setTheme();

            $('body').on('DARK_THEME_CHANGED', function () {
                setTheme();
            })

            editor.setReadOnly(true);
            var Range = ace.require('ace/range').Range;
            editor.setOption("showPrintMargin", false)
            editor.resize(true);

            $scope.isFileHashEqual = true;

            /**
             * @param search
             * @param replacement
             * @returns {*|string}
             */
            String.prototype.replaceAll = function (search, replacement) {
                var target = this;
                return target.replace(new RegExp(search, 'g'), replacement);
            };


            $scope.$watch('fileContents', function (value) {
                if (typeof value === "object" && value !== null) {
                    value = JSON.stringify(value, null, 4)
                }
                editor.setValue(value, -1);
                editor.scrollToLine(1, true, true, function () {
                });
            })

            $scope.$watch('policiesInfo', function (policyData) {
                //Clear old markers
                if (markers.length > 0) {
                    markers.forEach(function (marker, index) {
                        editor.session.removeMarker(marker);
                    })
                    markers = [];
                }

                if (policyData.length > 0) {
                    policyData.forEach(function (v) {
                        var promiseoutcomes = Array.isArray(v.promiseoutcome) ? v.promiseoutcome.join('line ').toLowerCase() : v.promiseoutcome.replace(/\{|\}/g, '').toLowerCase();
                        promiseoutcomes += "line";
                        if (v.line > 0) {
                            editor.resize(true);
                            var marker = editor.session.addMarker(new Range(v.line - 1, 0, v.line - 1, 1), promiseoutcomes, "fullLine");
                            markers.push(marker)
                        }
                    });
                }
            })

            $scope.$watch('policyLineSelected', function (lineNumber) {
                if (lineNumber === undefined) return;
                editor.scrollToLine(lineNumber, true, true, function () {
                });
                editor.gotoLine(lineNumber, 10, true);
            });

        }
    };

});
