import { createSlice } from '@reduxjs/toolkit';
import { saveReport } from './thunks';

interface ReportsState {
    reports: [];
    isLoading: boolean;
    error: string|null;
}

const initialState: ReportsState = {
    reports: [],
    isLoading: false,
    error: null,
};

const aiChatSlice = createSlice({
    name: 'reports',
    initialState,
    reducers: {},
    extraReducers: (builder) => {
        builder
            .addCase(saveReport.pending, (state) => {
                state.isLoading = true;
                state.error = null;
            })
            .addCase(saveReport.fulfilled, (state, action) => {
                state.isLoading = false;
                state.reports = action.payload;
            })
            .addCase(saveReport.rejected, (state, action) => {
                state.isLoading = false;
                state.error = action.payload?.[0]?.text || 'Failed to save report.';
            });
    },
});

export default aiChatSlice.reducer;
